/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.management.config;

import java.util.Map;

import org.jvnet.glassfish.comms.admin.management.extensions.SIPXTypes;
import com.sun.appserv.management.config.NamedConfigElement;
import com.sun.appserv.management.base.Container;

/**
 *     Configuration for the &lt;identity-assertion-trust&gt; element.
 */

public interface IdentityAssertionTrustConfig
        extends NamedConfigElement, Container
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String    J2EE_TYPE    = SIPXTypes.IDENTITY_ASSERTION_TRUST_CONFIG;

    /**
        Gets the trust config identifier
    public String getId();
     */

    /**

    /**
        Flag to mark/unmark the trust config as default. There can
        only be one trust config as default.
     */
    public boolean getIsDefault();

    /**
        @see #getIsDefault
     */
    public void    setIsDefault( final boolean value );

    // -------------- Operations
    /**
        Creates new trust-handler element.
        @param className Trust handler implementation class name
        @return Proxy to the TrustHandlerConfig MBean
     */    
    public TrustHandlerConfig createTrustHandlerConfig( String className);
  
    /**
        @return Proxy to the TrustHandlerConfig MBean
     */
    public TrustHandlerConfig getTrustHandlerConfig();

    /**
        Removes an existing trust-handler-element
     */
    public void removeTrustHandlerConfig();

    /**
        Creates a new trusted-entity element.
        @param optional Optional parameters
        @return Proxy to TrustedEntityConfig MBean
     */
    public TrustedEntityConfig createTrustedEntityConfig( Map<String,String> optional);

    /**
        Get a proxy to TrustedEntityConfig MBean
     */
    public TrustedEntityConfig getTrustedEntityConfig();

    /**
        Removes a trusted-entity
        @param id Name of the trusted entity to be removed
     */
    public void removeTrustedEntityConfig( String id);
}
