/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
 
package org.jvnet.glassfish.comms.management.config;

import java.util.Map;
import java.util.Date;

import org.jvnet.glassfish.comms.admin.management.extensions.SIPXTypes;

import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.ConfigElement;

/**
   Configuration for the sip-container-availability element.
 */
public interface SIPContainerAvailabilityConfig extends
        ConfigElement, PropertiesAccess
{

    /** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String  J2EE_TYPE = SIPXTypes.SIP_CONTAINER_AVAILABILITY_CONFIG;

    /**
     * Gets the state of SIP container availability, that is if 
     * its enabled/disabled.
     */
    public boolean  getAvailabilityEnabled();

    /**
     * Sets the SIP container availability
     */ 
    public void     setAvailabilityEnabled( final boolean value );

    /**
     *  Gets the SIP session persistence mechanism for SIP
     *  applications that have availability enabled. Default is
     *  "memory".
     */
    public String getPersistenceType();

    /**
     *  Sets the SIP session persistence mechanism for SIP
     *  applications that have availability enabled.
     *  See {@link PersistenceTypeValues}.
     */
    public void setPersistenceType( final String value);

    /**
     * Gets the persistence frequency used by the session persistence
     * framework.
     */
    public String getPersistenceFrequency();

    /**
     * Sets the persistence frequency.
     * See {@link SIPSessionSaveFrequencyValues}.
     */
    public void setPersistenceFrequency( final String value);

    /**
     * Gets the persistence scope used by the session persistence
     * framework.
     */
    public String getPersistenceScope();

    /**
     * Sets the persistence scope used by the session persistence 
     * framework.
     * See {@link SessionSaveScopeValues}.
     */
    public void setPersistenceScope( final String value);

    /**
     * Gets whether a forward and reverse repair should be
     * performed on an instance that has (re)joined the cluster.
     */
    public boolean getRepairDuringFailure();

    /**
     * Sets if a forward and reverse repair should be performed
     * on an instance that has (re)joined the cluster.
     */
    public void setRepairDuringFailure( final boolean value);
}
