/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.management.config;

import java.util.Map;

import javax.management.AttributeList;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.ConfigElement;
import com.sun.appserv.management.config.SessionConfig;

import org.jvnet.glassfish.comms.admin.management.extensions.SIPXTypes;
/**
     Configuration for an &lt;sip-container&gt; element.
*/
public interface SIPContainerConfig
    extends PropertiesAccess, Container, ConfigElement
{
    /** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String    J2EE_TYPE    = SIPXTypes.SIP_CONTAINER_CONFIG;

    /**
            Get the SessionConfig.
     */
    public SessionConfig getSessionConfig();

    /**
            Creates session-config element.

            @return A proxy to the SessionConfig MBean.
     */
    public SessionConfig createSessionConfig();

    /**
            Removes session-config element.
     */
    public void removeSessionConfig();

/*
    // Future support for stack config via AMX
    public StackConfig getStackConfig();

    public StackConfig createStackConfig();

    public void removeStackConfig();
*/

}
