/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.clb.admin;

import java.io.IOException;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.event.AdminEventListenerException;

import com.sun.enterprise.config.serverbeans.*;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.List;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.impl.SynchronizationClientImpl;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jvnet.glassfish.comms.admin.event.extensions.clb.*;
import org.jvnet.glassfish.comms.clb.core.sip.SipLoadBalancerManagerBackEnd;
import org.jvnet.glassfish.comms.util.LogUtil;

public class ConvergedLBPolicyEventListenerImpl implements ConvergedLbPolicyEventListener {
     static final String CONFIG = "config";
     static final String CLB_DCR_FILE="dcr-file";
    /**
     * Creates a new instance of ConvergedLBEventListenerImpl
     */
    public ConvergedLBPolicyEventListenerImpl() {
    }

    public void handleCreate(ConvergedLbPolicyEvent e) throws AdminEventListenerException
    {
        try{
          synchronizeDCRXml(e);
        }catch(SynchronizationException ex)
        {
            _logger.log(Level.SEVERE, "File Synchronization of DCR file with DAS failed " + ex.getMessage());
            throw new AdminEventListenerException(ex.getMessage());
        }
    }

    public void handleDelete(ConvergedLbPolicyEvent e) throws AdminEventListenerException
    {
         try{
          synchronizeDCRXml(e);
        }catch(SynchronizationException ex)
        {
            _logger.log(Level.SEVERE, "File Synchronization of DCR file with DAS failed " + ex.getMessage());
            throw new AdminEventListenerException(ex.getMessage());
        }
    }
    public void handleUpdate(ConvergedLbPolicyEvent e) throws AdminEventListenerException
    {
       try{
          synchronizeDCRXml(e);
        }catch(SynchronizationException ex)
        {
            _logger.log(Level.SEVERE, "File Synchronization of DCR file with DAS failed " + ex.getMessage());
             throw new AdminEventListenerException(ex.getMessage());
        }
    }
    protected void synchronizeDCRXml(ConvergedLbPolicyEvent e) throws SynchronizationException {

        // connects to DAS
        String dasName = SystemPropertyConstants.DEFAULT_SERVER_INSTANCE_NAME;
        // current server name
        String serverName=ApplicationServer.getServerContext().
                            getInstanceName();
        String[] dcrXMLFile = getDCRFileName(e, serverName);
        if(dcrXMLFile == null) return; //no-op

        String dcrXMLNewFile= dcrXMLFile[0];
        String dcrXMLOldFile= dcrXMLFile[1];

        SynchronizationClientImpl sc = new SynchronizationClientImpl(dasName);

        _logger.log(Level.INFO,
                    "Start: Synchronizing DCR XML file from DAS. DAS NAME: " + dasName );
        try {
            sc.connect();
            _logger.log(Level.FINEST,
                    "Dynamic Reconfig: Successfully connected to DAS" );
        } catch (IOException ie) {
           throw new SynchronizationException("Connection to SynchronizationClientImpl failed. IOException occured while trying to connect " + ie.getMessage());
        }
        String instanceRoot = System.getProperty(SystemPropertyConstants.INSTANCE_ROOT_PROPERTY);

        String configName = getConfigName(e, serverName);

        String clbTargetLocation = instanceRoot + File.separator + CONFIG + File.separator + configName;

        //Added as a workaround for scenario when config-dir does not exist
        //under instance config
        final File clbTargetDir = new File(clbTargetLocation);
        if (!clbTargetDir.exists()) {
            try {
                AccessController.doPrivileged(new PrivilegedAction() {
                    public Object run() {
                        clbTargetDir.mkdir();
                        return null;
                    }
                });
            } catch (SecurityException ex) {
                throw new SynchronizationException(
                    "Unable to create directory " + clbTargetLocation, ex);
            }
        }
        
        _logger.log(Level.FINEST,
                    "Dynamic Reconfig: Fetching file from DAS. Source File - " + dcrXMLNewFile + " Target Location - " + clbTargetLocation );

        sc.get(CONFIG + File.separator +  configName +  File.separator + dcrXMLNewFile, clbTargetLocation + File.separator + dcrXMLNewFile);


        _logger.log(Level.INFO,
                    "Synchronization of DCR file completed sucessfully to " + clbTargetLocation);
        
        //Reconfiguring sip load-balancer back-end dcr xml
        if (SipLoadBalancerManagerBackEnd.isLayerActive()) {
            SipLoadBalancerManagerBackEnd.getInstance().dcrReconfig(configName + File.separator + dcrXMLNewFile);
        }

     if (dcrXMLOldFile != null){
        try {
            _logger.log(Level.INFO,
                               "Deleting the old DCR file- " + dcrXMLOldFile);

                File oldDCRFile= new File(clbTargetLocation + File.separator + dcrXMLOldFile);
                boolean value = oldDCRFile.delete();
                if (value == false)
                    _logger.log(Level.WARNING, "Unable to delete " + dcrXMLOldFile);                     
        }catch(SecurityException se){
              _logger.log(Level.WARNING, "Unable to delete " + dcrXMLOldFile + ". Error Message: " + se.getMessage());
        }
     }
        try {
            sc.disconnect();
        } catch (IOException ie) {
           throw new SynchronizationException("Unable to close connection to DAS");
        }
    }

 /**
     * method to get the config name from the event's config context
     * @param e - the event
     * @param serverName
     * @return - the name of the Config from the config context. Else returns null
     */

    private String getConfigName(ConvergedLbPolicyEvent e, String serverName)
                throws SynchronizationException {
        ConfigContext _ctx = e.getConfigContext();
        try {
            if (_ctx == null ) {
                throw new RuntimeException("ConfigContext is null");
            }
            Config config = ServerHelper.getConfigForServer(_ctx,serverName);
            if (config == null ) {
                throw new RuntimeException("ServerHelper.getConfigForServer is null");
            }

            return config.getName();

        } catch (ConfigException ce) {
            throw new SynchronizationException("Unable to resolve configuration name");
        }

    }

   /**
     * method to check if the dcr file is one of the attributes that has changed.
     * @param e - the event
     * @param serverName
     * @return - the names of the dcr files from the change list.
     *           [0]= New DCR file name
     *           [1]= old DCR file name
     *           Else returns null
     */

    private String[] getDCRFileName(ConvergedLbPolicyEvent e, String serverName ){

        List changeList = e.getConfigChangeList();
        String[] changeValues = null;
         for (int i =0; i < changeList.size(); i++)
        {
                ConfigChange change = (ConfigChange) changeList.get(i);

                 if (change!= null && change instanceof ConfigUpdate)
                 {
                      changeValues = new String[2];
                      changeValues[0]= ((ConfigUpdate)change).getNewValue(CLB_DCR_FILE);
                      changeValues[1]= ((ConfigUpdate)change).getOldValue(CLB_DCR_FILE);
                     _logger.log(Level.INFO, "DCR File name in the change list - " + changeValues[0]);
                      return changeValues;

                }
        }
         return null;

    }

    private static final Logger _logger = LogUtil.CLB_LOGGER.getLogger();



}

