/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core;

import com.sun.grizzly.tcp.Response;
import java.util.logging.Logger;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;
import org.jvnet.glassfish.comms.util.LogUtil;

import java.util.ArrayList;
import java.util.logging.Level;


/**
 *
 * @author kshitiz
 */
public class HttpRequestGroup implements RequestGroup {
    private static final Logger _logger = LogUtil.CLB_LOGGER.getLogger();
    private String appName;
    private ArrayList<ServerCluster> clusters;
    Router router;
    String lbpolicy;
    private Controller controller;
    private boolean isConsistentHashPolicy;

    /** Creates a new instance of HttpRequestGroup */
    public HttpRequestGroup(Controller controller, String appName) {
        this.controller = controller;
        this.appName = appName;
        clusters = new ArrayList<ServerCluster>();
    }

    public void addCluster(ServerCluster cluster) {
        clusters.add(cluster);
    }

    public void deleteCluster(ServerCluster cluster) {
        clusters.remove(cluster);
    }

    public void initializeRouter(String lbpolicy) throws CLBRuntimeException {
        if(_logger.isLoggable(Level.FINE))
            _logger.log(Level.FINE,
                    "clb.intializing_router_for_request_group",
                    new Object[]{appName});
        this.lbpolicy = lbpolicy;

        if (lbpolicy.equals(RouterFactory.LBPolicy_CONSISTENT_HASH)) {
            router = RouterFactory.createRouter(RouterFactory.LBPolicy_STICKY_CONSISTENT_HASH,
                    clusters, false);
            isConsistentHashPolicy = true;
        } else if (lbpolicy.equals(RouterFactory.LBPolicy_ROUND_ROBIN)) {
            router = RouterFactory.createRouter(RouterFactory.LBPolicy_STICKY_ROUND_ROBIN,
                    clusters, false);
        } else {
            router = RouterFactory.createRouter(lbpolicy, clusters, false);
        }

        router.setController(controller);
        router.initialize();
        if(_logger.isLoggable(Level.FINE))
            _logger.log(Level.FINE,
                    "clb.intialized_router_for_request_group",
                    new Object[]{router, appName, lbpolicy});
    }

    public void reinitializeRouter() throws CLBRuntimeException {
        if(_logger.isLoggable(Level.FINE))
            _logger.log(Level.FINE,
                    "clb.reintializing_router_for_request_group",
                    new Object[]{appName});
        router = RouterFactory.createRouter(lbpolicy, clusters, false);
        router.setController(controller);
        if(_logger.isLoggable(Level.FINE))
            _logger.log(Level.FINE,
                    "clb.reintialized_router_for_request_group",
                    new Object[]{appName});
    }

    public void serviceRequest(HttpRequest req, Response res) {
        //increment counter of the number of request being currently serviced
        controller.incrementRequestCount();

        if(_logger.isLoggable(Level.FINE))
            _logger.log(Level.FINE,
                    "clb.request_group_servicing_request",
                    new Object[]{appName, req.requestURI().toString()});

        EndPoint endPoint = null;

        ServerInstance instance = null;

        ConsistentHashRequest chrRequest = null;

        if (isConsistentHashPolicy) {
            chrRequest = new ConsistentHashRequest(req, null);
        }

        do {
            if (isConsistentHashPolicy) {
                instance = router.selectInstance(chrRequest);
            } else {
                instance = router.selectInstance(req);
            }
            
            if(instance == null){
                _logger.log(Level.SEVERE,
                    "clb.no_instance_found_to_service_request",
                    new Object[]{appName, req.requestURI().toString()});
                req.setConvergedLoadBalancerEndpoint(null);
                return;
            }

            if(_logger.isLoggable(Level.FINE))
            _logger.log(Level.FINE,
                    "clb.instance_selected_to_service_request",
                    new Object[]{appName, instance.getName(), req.requestURI().toString()});

            boolean secure = req.isSecure();

            if (secure) {
                /* TBD
                 * As of now, ssl-offloading is done by default. May be it can be enabled/disabled
                 * using a property later
                 */

                //endPoint = instance.getEndPoint(CLBConstants.HTTPS_PROTOCOL);
                if(_logger.isLoggable(Level.FINE))
                    _logger.log(Level.FINE,
                            "clb.offloading_ssl_request",
                            new Object[]{appName, req.requestURI().toString()});
                endPoint = instance.getEndPoint(CLBConstants.HTTP_PROTOCOL);
            } else {
                endPoint = instance.getEndPoint(CLBConstants.HTTP_PROTOCOL);
            }

            if (endPoint != null) {
                break;
            }

            _logger.log(Level.SEVERE,
                    "clb.no_suitable_endpoint",
                    new Object[]{ instance.getName(), appName, req.requestURI().toString()});
        } while (true);

        if(_logger.isLoggable(Level.FINE))
            _logger.log(Level.FINE,
                    "clb.selected_end_point",
                    new Object[]{appName, endPoint.getHost(),
                    endPoint.getPort(), instance.getName(), req.requestURI().toString()});

        req.setConvergedLoadBalancerEndpoint(endPoint);

        if (lbpolicy.equals(RouterFactory.LBPolicy_ROUND_ROBIN)) {
            req.addHeader(CLBConstants.PROXY_HEADER_BEROUTE_KEY,
                instance.getID());
        } else if (lbpolicy.equals(RouterFactory.LBPolicy_CONSISTENT_HASH)) {
            req.addHeader(CLBConstants.PROXY_HEADER_BEKEY_KEY,
                chrRequest.getHashKey());
        } else {
            _logger.log(Level.SEVERE, "clb.unknown_load_balancing_policy");
        }

        //decrement counter of the number of request being currently serviced
        controller.decrementRequestCount();
    }

    public void cleanup() {
        if(_logger.isLoggable(Level.FINE))
            _logger.log(Level.FINE,
                    "clb.cleaning_up_request_group",
                    new Object[]{appName});
        clusters = null;
        controller = null;
        if(_logger.isLoggable(Level.FINE))
            _logger.log(Level.FINE,
                    "clb.cleaned_up_request_group",
                    new Object[]{appName});
    }
}
