/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;


/**
 * This is interface which maintains the complete/active list of instances available for load-balancing.
 * The load-balancing policy and clusters part are integral part of a
 * router. The router is initimated of cluster membership changes. It maintains a complete list of
 * instances. This include healthy, unhealthy, enabled and disabled instances. It also maintains a active
 * list of instances which include only healthy and enabled instances. All the requests are router to
 * instances part of the active list.
 *
 * @author kshitiz
 */
public interface Router {
    /**
     * Initializes the router.
     *
     * @return true if initialization is successful
     */
    public boolean initialize();

    /**
     * Select an instance based on request.
     *
     * @param req the request object
     *
     * @return returns the instance to which this request should be forwarded
     */
    public ServerInstance selectInstance(HttpRequest req);

    /**
     * Select an instance based on request.
     *
     * @param req the request object
     *
     * @return returns the instance to which this request should be forwarded
     */
    public ServerInstance selectInstance(ConsistentHashRequest req);

    /**
     * this method handles the event of instance being disabled
     *
     * @param instance instance being disabled
     */
    public void handleDisableEvent(ServerInstance instance);

    /**
     * this method handles the event of instance being enabled
     *
     * @param instance instance being enabled
     */
    public void handleEnableEvent(ServerInstance instance);

    /**
     * this method handles the event of instance becoming healthy
     *
     * @param instance instance becoming healthy
     */
    public void handleRecoveryEvent(ServerInstance instance);

    /**
     * this method handles the event of instance becoming unhealthy
     *
     * @param instance instance becoming unhealthy
     */
    public void handleFailureEvent(ServerInstance instance);

    /**
     * Sets the controller on router
     * @param controller associated controller
     */
    public void setController(Controller controller);
}
