/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.SipServletRequest;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 * Extracts a hash key by querying the contained extractors, in the reverse
 * order they where added, i.e. starting with the last one added. The first that
 * returns a non-null value is used. If none produces a hash key, null is
 * returned.
 */
public class CompositeHashKeyExtractor implements HashKeyExtractor,
    Iterable<HashKeyExtractor> {
    private List<HashKeyExtractor> extractors = new ArrayList<HashKeyExtractor>();
    private Logger logger = LogUtil.CLB_LOGGER.getLogger();

    public void push(HashKeyExtractor hke) {
        extractors.add(0, hke);
    }

    public String getHashKey(HttpRequest request) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE,
                "clb.number_of_hask_key_extractors",
                new Object[]{extractors.size()});
        }
        for (HashKeyExtractor extractor : extractors) {
            String hk = extractor.getHashKey(request);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE,
                    "clb.value_of_key_extracted_by_extractor",
                    new Object[]{extractor, hk});
            }
            if (hk != null) {
                return hk;
            }
        }

        return null;
    }

    public String getHashKey(SipServletRequest request) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE,
                "clb.number_of_hask_key_extractors",
                new Object[]{extractors.size()});
        }
        for (HashKeyExtractor extractor : extractors) {
            String hk = extractor.getHashKey(request);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE,
                    "clb.value_of_key_extracted_by_extractor",
                    new Object[]{extractor, hk});
            }
            if (hk != null) {
                return hk;
            }
        }

        return null;
    }

    public Iterator<HashKeyExtractor> iterator() {
        // Avoid concurrent modification when iterating...
        return ((ArrayList<HashKeyExtractor>) ((ArrayList<HashKeyExtractor>) extractors).clone()).iterator();
    }
}
