/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr;

import java.util.List;

import org.jvnet.glassfish.comms.clb.core.ConsistentHashRequest;
import org.jvnet.glassfish.comms.clb.core.ServerCluster;
import org.jvnet.glassfish.comms.clb.core.ServerInstance;


/**
 * This is a router that is based on consistent hashing but uses primarily a
 * {@link StickyHashKeyExtractor} (secondarily the default hash key extraction of the base class {@link ConsistentHashRouter}) to extract the hash key from the request.
 */
public class StickyConsistentHashRouter extends ConsistentHashRouter {
    
    /**
     * Creates an instance.
     * See {@link RouterFactory} for more information about arguments.
     */
    public StickyConsistentHashRouter(List<ServerCluster> associatedClusters,
        boolean activeRouting) {
        super(associatedClusters, activeRouting);
    }
    
    /**
     * Gets the server instance for the specified request.
     *
     * @param req the request
     * @return the server instance for the given hash key
     */
    @Override
    protected ServerInstance getServerInstance(ConsistentHashRequest req) {
        if (req.getHashKey() == null) {
            return null;
        }

            ServerInstance server = null;

            if (!ignoreIdealHash) {
                // First try "ideal" router
                ServerWrapper serverWrapper = idealConsistentHash.get(req.getHashKey());
                if (serverWrapper != null) {
                    server = serverWrapper.getServerInstance();
                    
                    /* Need to select another instance from cluster in below cases
                     * 1. Instance is unhealthy
                     * 2. Instance is disabled. In consistent hash router,
                     *    we do not worry about instance being quiesced or not
                     */
                    if (!server.isHealthy() ||
                            server.isDisabled()) {
                        //select another instance from cluster
                        server = ((ConsistentHashRouter) server.getServerCluster()
                                                               .getClusterRouter()).selectInstance(req);
                    }
                }
            }

            if (server == null) {
                server = getActiveInstance(req);
            }

            return server;
    }
}
