/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr.dcr;

import javax.servlet.sip.SipServletRequest;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;
import org.w3c.dom.Element;

import com.sun.grizzly.util.http.Cookies;
import com.sun.grizzly.util.http.ServerCookie;


public class CookieCondition extends Operand {
    private static final long serialVersionUID = 1L;
    private String cookieName = null;

    public CookieCondition() {
    }

    public static String getCookieValue(Cookies cookies, String cookieName,
        String defaultValue) {
        if (cookies == null) {
            return defaultValue;
        }

        for (int i = 0; i < cookies.getCookieCount(); i++) {
            ServerCookie cookie = cookies.getCookie(i);

            if (cookieName.equals(cookie.getName().toString())) {
                return (cookie.getValue().toString());
            }
        }

        return (defaultValue);
    }

    @Override
    public void addChild(Element element) {
        super.addChild(element);
    }

    @Override
    public void addElmentData(Element element) {
        cookieName = element.getAttribute("name");

        String returnCondition = element.getAttribute("return");

        if (returnCondition != null) {
            setReturnCondition(returnCondition);
        }
    }

    @Override
    public String evaluate(Object request) {
        int conditionType = getConditionType();

        String cookieVal = null;

        if (cookieName == null) {
            return null;
        }

        if (request instanceof SipServletRequest) {
            return null; // only applicable for SIP
        } else if (request instanceof HttpRequest) {
            cookieVal = getCookieValue(((HttpRequest) request).getCookies(),
                    cookieName, null);

            switch (conditionType) {
            case TYPE_DEFINED:

                if (cookieVal != null) {
                    return processReturnLogic(request, getReturnCondition());
                } else {
                    return null;
                }

            case TYPE_UNDEFINED:

                if (cookieVal == null) {
                    return processReturnLogic(request, getReturnCondition());
                } else {
                    return null;
                }
            }
        }

        return null;
    }
}
