/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr.dcr;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;
import org.w3c.dom.Element;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.sip.SipServletRequest;


public class RequestUriCondition extends Operand {
    private static final long serialVersionUID = 1L;
    private String parameterName = null;

    public RequestUriCondition() {
    }

    @Override
    public void addChild(Element element) {
        super.addChild(element);
    }

    @Override
    public void addElmentData(Element element) {
        parameterName = element.getAttribute("parameter");

        String returnCondition = element.getAttribute("return");

        if (returnCondition != null) {
            setReturnCondition(returnCondition);
        }
    }

    @Override
    public String evaluate(Object request) {
        int conditionType = getConditionType();

        String parameterVal = null;

        if (request instanceof SipServletRequest) {
            parameterVal = ((SipServletRequest) request).getParameter(parameterName);
        } else if (request instanceof HttpRequest) {
            parameterVal = ((HttpRequest) request).getParameters().getParameter(parameterName);
        }

        if (parameterName == null) {
            return null;
        }

        switch (conditionType) {
        case TYPE_DEFINED:

            if (parameterVal != null) {
                return processReturnLogic(request, getReturnCondition());
            } else {
                return null;
            }

        case TYPE_UNDEFINED:

            if (parameterVal == null) {
                return processReturnLogic(request, getReturnCondition());
            } else {
                return null;
            }

        case TYPE_MATCH:

            try {
                Pattern reqUriPattern = getMatchExpression();

                if (reqUriPattern == null) {
                    return null;
                }

                String requestUri = null;

                if (request instanceof SipServletRequest) {
                    // URI requestUri = ((SipServletRequest) request
                    // ).getRequestURI(); // TODO should never happen
                    /*
                     * This fix shoule provide match and match.resolve.user for
                     * SIP as well. New JUnit and add to QS and SAD. Old test
                     * still work so add new code next time.
                     */
                    requestUri = ((SipServletRequest) request).toString();
                } else if (request instanceof HttpRequest) {
                    requestUri = ((HttpRequest) request).requestURI().toString();
                }

                Matcher m = reqUriPattern.matcher(requestUri);

                if (!m.find()) {
                    return null; // no match
                }

                if (m.groupCount() >= 1) {
                    if (returnCondition.equals("match")) {
                        return m.group(1);
                    }

                    if (returnCondition.equals("match.resolve.user")) {
                        return DcrUtils.getInstance().getUserPart(m.group(1));
                    }
                } else {
                    return "In order to get a return value a group has to be specified in the pattern"; // did
                                                                                                        // match but nor return value
                }
            } catch (Exception e) {
                return null;
            }
        }

        return null;
    }
}
