/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core.sip;

import com.ericsson.ssa.config.Constants;

import javax.servlet.http.Cookie;

import org.apache.catalina.Session;
import org.apache.catalina.core.ResponseProcessor;
import org.apache.catalina.core.StandardContext;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;

/**
 * Implementation of ResponseProcessor interface responsible for examining
 * an HTTP request for proxy-beroute and proxy-bekey headers, and adding their
 * values to the response (as cookies) or rewritten URL (if cookies have been
 * disabled).
 *
 * @author jluehe
 */
public class CLBHttpResponseProcessor implements ResponseProcessor {

    private static final ResponseProcessor SINGLETON =
        new CLBHttpResponseProcessor();

    private CLBHttpResponseProcessor() {}

    static ResponseProcessor getInstance() {
        return SINGLETON;
    }

    /**
     * Checks the request associated with the given response for 
     * proxy-bekey and proxy-beroute headers and adds their values as
     * cookies to the given response.
     *
     * @param response The response to which to add the cookie
     */
    public void addCookies(StandardContext context, CoyoteResponse response) {
        if (!context.getCookies()) {
            // cookies have been disabled
            return;
        }

        CoyoteRequest request = (CoyoteRequest) response.getRequest();
        if (request == null) {
            return;
        }

        Session sess = request.getSessionInternal(false);
        if (sess == null) {
            // No active session
            return;
        }

        Cookie cookie = null;
        String value = request.getHeader(Constants.PROXY_BEROUTE_HEADER);
        if (value != null) {
            cookie = new Cookie(Constants.BEROUTE, value);
        } else {
            value = request.getHeader(Constants.PROXY_BEKEY_HEADER);
            if (value != null) {
                cookie = new Cookie(Constants.BEKEY, value);
            }
        }

        if (cookie != null) {
            request.configureSessionCookie(cookie);
            response.addCookie(cookie);
        }
    }

    /**
     * Checks the given request for proxy-bekey and proxy-beroute headers
     * and adds their values to the given string buffer.
     *
     * @param request The request to examine
     * @param sb The StringBuffer to hold the encoded result
     */
    public void encodeRequest(CoyoteRequest request, StringBuffer sb) {
        String value = request.getHeader(Constants.PROXY_BEROUTE_HEADER);
        if (value != null) {
            sb.append(Constants.BEROUTE_URI_PARAMETER);
            sb.append(value);
        } else {
            value = request.getHeader(Constants.PROXY_BEKEY_HEADER);
            if (value != null) {
                sb.append(Constants.BEKEY_URI_PARAMETER);
                sb.append(value);
            }
        }
    }
}
