/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.proxy;


import org.jvnet.glassfish.comms.clb.proxy.api.Endpoint;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;


/**
 * This is an implementation of an Endpoint which holds the host, port
 * and protocol details of an instance. This is similar to the TargetTuple
 * implementation in SIP stack.
 *
 * @author rampsarathy
 */
public class DefaultEndpoint implements Endpoint {
    /**
     * Host name.
     */
    protected String host = null;
    
    /**
     * Port number.
     */
    protected int port = 0;
    
    /**
     * Socket address corresponding to this host.
     */
    protected SocketAddress socket = null;
    
    /**
     * Denotes if the endpoint is local
     */
    protected boolean local = false;
    
    /**
     * Is this a TLS endpoint.
     */
    protected boolean secure = false;
    
    /** Creates a new instance of DefaultEndpoint */
    public DefaultEndpoint() {
        this("localhost", 8080);
    }
    
    public DefaultEndpoint(String host, int port) {
        this.host = host;
        this.port = port;
        this.socket = null;
    }
    
    public DefaultEndpoint(SocketAddress address) {
        this.socket = address;
    }
    
    public SocketAddress getSocketAddress() {
        if (this.socket == null) {
            this.socket = new InetSocketAddress(this.host, this.port);
        }
        
        return this.socket;
    }
    
    public void setHost(String host) {
        this.host = host;
    }
    
    public InetAddress getIp() {
        if (this.socket == null) {
            this.socket = new InetSocketAddress(this.host, this.port);
        }
        
        return ((InetSocketAddress) (this.socket)).getAddress();
    }
    
    public void setPort(int port) {
        this.port = port;
    }
    
    public int getPort() {
        if (this.socket == null) {
            this.socket = new InetSocketAddress(this.host, this.port);
        }
        
        return ((InetSocketAddress) (this.socket)).getPort();
    }
    
    /**
     *
     *
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        
        Endpoint ep = (Endpoint) obj;
        
        if (port != ep.getPort()) {
            return false;
        }
        
        if ((this.getIp() != null) && !this.getIp().equals(ep.getIp())) {
            return false;
        }
        
        if (this.isSecure() != ep.isSecure()) {
            return false;
        }
        
        return true;
    }
    
    public void setSecure(boolean secure) {
        this.secure = secure;
    }
    
    public boolean isSecure() {
        return this.secure;
    }
    
    public void setLocal(boolean local) {
        this.local = local;
    }
    
    public boolean isLocal() {
        return this.local;
    }
    
    /**
     *
     *
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        return this.getIp().hashCode() ^ this.port;
    }
    
    public String key() {
        String key = null;
        
        if (this.isSecure()) {
            key = "tls:" + this.getIp() + ":" + this.getPort();
        } else {
            key = "tcp:" + this.getIp() + ":" + this.getPort();
        }
        
        return key;
    }
    
    public String toString() {
        return this.key();
    }
}
