/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.proxy.http.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jvnet.glassfish.comms.clb.proxy.ProxyRequestHandler;
import org.jvnet.glassfish.comms.clb.proxy.config.LoadBalancerProxyConstants;
import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;


/**
 * This is an object manager implementation using the ConcurrentQueue from
 * grizzly.
 *
 * @author rampsarathy
 */
public class ObjectManager {
    private static ObjectManager _thisInstance = null;
    private ArrayBlockingQueue<ProxyRequestHandler> tasks;
    private ArrayBlockingQueue<ProxyRequestHandler> ssltasks;
    /** Creates a new instance of ObjectManager */
    private ObjectManager() {
    }

    public static synchronized ObjectManager getInstance() {
        if (_thisInstance == null) {
            _thisInstance = new ObjectManager();
        }
        return _thisInstance;
    }

    public void initialize() {
        tasks = new ArrayBlockingQueue(
                ProxyConfig.getInstance().getRequestPoolSize());

        for (int i = 0; i < ProxyConfig.getInstance().getRequestPoolSize(); i++) {
            tasks.offer(new ProxyRequestHandler(false));
        }

        ssltasks = new ArrayBlockingQueue(
                ProxyConfig.getInstance().getRequestPoolSize());

        for (int i = 0; i < ProxyConfig.getInstance().getRequestPoolSize(); i++) {
            ssltasks.offer(new ProxyRequestHandler(true));
        }
    }

    public ProxyRequestHandler pollTask(boolean secure) {
        /**
         *  Could be improved to include resizing logic.
         */
        ProxyRequestHandler handler = null;
        try {
            if (secure) {
                handler =  ssltasks.poll(
                            LoadBalancerProxyConstants.REQUEST_POLL_TIMEOUT,
                            TimeUnit.SECONDS);

            } else {
                handler = tasks.poll(
                            LoadBalancerProxyConstants.REQUEST_POLL_TIMEOUT,
                            TimeUnit.SECONDS);
            }
        } catch (InterruptedException ex) {
            handler = null;
        }
        return handler;
    }

    @SuppressWarnings("empty-statement")
    public void offerTask(ProxyRequestHandler task, boolean secure) {
        try {
            if (secure) {
                /**
                 *  The task queues will never grow beyond the pool size
                 *  so its not necessary to use the offer API with the wait.
                 */
                ssltasks.offer(task);
            } else {
                tasks.offer(task);
            }
        } catch (Exception e) {
            ;
        }
    }
}
