/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.proxy.util;

import com.sun.grizzly.util.SSLUtils;
import com.sun.grizzly.util.SelectorFactory;


import java.io.IOException;

import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

import javax.net.ssl.SSLEngine;


/**
 *
 * @author Jeanfrancois Arcand
 */
public class Reader {
    // Taken from ByteBufferInputStream impl
    public static int read(ByteBuffer byteBuffer, SocketChannel channel,
        int readTimeout) throws IOException {
        byteBuffer.clear();

        int count = 1;
        int byteRead = 0;
        Selector readSelector = null;
        SelectionKey tmpKey = null;

        try {
            while (count > 0) {
                count = channel.read(byteBuffer);

                if (count > -1) {
                    byteRead += count;
                } else {
                    byteRead = count;
                }
            }

            if (byteRead == 0) {
                readSelector = SelectorFactory.getSelector();

                if (readSelector == null) {
                    return 0;
                }

                count = 1;

                tmpKey = null;
                tmpKey = channel.register(readSelector, SelectionKey.OP_READ);
                tmpKey.interestOps(tmpKey.interestOps() | SelectionKey.OP_READ);

                int code = readSelector.select(readTimeout);
                tmpKey.interestOps(tmpKey.interestOps() &
                    (~SelectionKey.OP_READ));

                if (code == 0) {
                    return 0; // Return on the main Selector and try again.
                }

                while (count > 0) {
                    count = channel.read(byteBuffer);

                    if (count > -1) {
                        byteRead += count;
                    } else {
                        byteRead = count;
                    }
                }
            }
        } finally {
            if (tmpKey != null) {
                tmpKey.cancel();
            }

            if (readSelector != null) {
                try {
                    readSelector.selectNow();
                } catch (IOException ex) {
                    ;
                }

                SelectorFactory.returnSelector(readSelector);
            }
        }

        byteBuffer.flip();

        return byteRead;
    }

    // Taken from sslbytbufferinputstream in grizzly
    public static int doSSLRead(ByteBuffer inputBB, ByteBuffer byteBuffer,
        SelectionKey key, int readTimeout) throws IOException {
        byteBuffer.compact();

        int initialPosition = byteBuffer.position();
        int byteRead = 0;

        // We need to make sure the unwrap worked properly and we have all
        // the packets properly read. If the SSLEngine fail to unwrap all the
        // bytes, the byteBuffer will be empty event if some encrypted bytes
        // are available.
        while (byteBuffer.position() == initialPosition) {
            int currentRead = SSLUtils.doSecureRead(key.channel(),
                    (SSLEngine) (key.attachment()), byteBuffer, inputBB);

            if (currentRead > 0) {
                byteRead += currentRead;
            }

            if ((currentRead > 0) || (inputBB.position() > 0)) {
                try {
                    byteBuffer = SSLUtils.unwrapAll(byteBuffer, inputBB,
                            (SSLEngine) (key.attachment()));
                } catch (IOException ex) {
                    ex.printStackTrace();

                    return -1;
                }
            } else {
                break;
            }
        }

        byteBuffer.flip();

        return byteRead;
    }
}
