/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.enterprise.config.serverbeans;

import org.w3c.dom.*;
import org.netbeans.modules.schema2beans.*;
import java.beans.*;
import java.util.*;
import java.io.Serializable;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.util.i18n.StringManager;

// BEGIN_NOI18N

public class IdentityAssertionTrust extends ConfigBean implements Serializable
{

	static Vector comparators = new Vector();
	private static final org.netbeans.modules.schema2beans.Version runtimeVersion = new org.netbeans.modules.schema2beans.Version(4, 2, 0);

	static public final String TRUSTED_ENTITY = "TrustedEntity";
	static public final String TRUST_HANDLER = "TrustHandler";

	public IdentityAssertionTrust() {
		this(Common.USE_DEFAULT_VALUES);
	}

	public IdentityAssertionTrust(int options)
	{
		super(comparators, runtimeVersion);
		// Properties (see root bean comments for the bean graph)
		initPropertyTables(2);
		this.createProperty("trusted-entity", TRUSTED_ENTITY, Common.SEQUENCE_OR | 
			Common.TYPE_0_N | Common.TYPE_BEAN | Common.TYPE_KEY, 
			TrustedEntity.class);
		this.createAttribute(TRUSTED_ENTITY, "id", "Id", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.createAttribute(TRUSTED_ENTITY, "trusted-as", "TrustedAs", 
						AttrProp.CDATA | AttrProp.IMPLIED,
						null, null);
		this.createProperty("trust-handler", TRUST_HANDLER, Common.SEQUENCE_OR | 
			Common.TYPE_1 | Common.TYPE_BEAN | Common.TYPE_KEY, 
			TrustHandler.class);
		this.createAttribute(TRUST_HANDLER, "class-name", "ClassName", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.initialize(options);
	}

	// Setting the default values of the properties
	void initialize(int options) {

	}

	// Get Method
	public TrustedEntity getTrustedEntity(int index) {
		return (TrustedEntity)this.getValue(TRUSTED_ENTITY, index);
	}

	// This attribute is an array, possibly empty
	public void setTrustedEntity(TrustedEntity[] value) {
		this.setValue(TRUSTED_ENTITY, value);
		if (value != null && value.length > 0) {
			// It's a mutually exclusive property.
			setTrustHandler(null);
		}
	}

	// Getter Method
	public TrustedEntity[] getTrustedEntity() {
		return (TrustedEntity[])this.getValues(TRUSTED_ENTITY);
	}

	// Return the number of properties
	public int sizeTrustedEntity() {
		return this.size(TRUSTED_ENTITY);
	}

	// Add a new element returning its index in the list
	public int addTrustedEntity(TrustedEntity value)
			throws ConfigException{
		return addTrustedEntity(value, true);
	}

	// Add a new element returning its index in the list with a boolean flag
	public int addTrustedEntity(TrustedEntity value, boolean overwrite)
			throws ConfigException{
		TrustedEntity old = getTrustedEntityById(value.getId());
		if(old != null) {
			throw new ConfigException(StringManager.getManager(IdentityAssertionTrust.class).getString("cannotAddDuplicate",  "TrustedEntity"));
		}
		return this.addValue(TRUSTED_ENTITY, value, overwrite);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	//
	public int removeTrustedEntity(TrustedEntity value){
		return this.removeValue(TRUSTED_ENTITY, value);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	// with boolean overwrite
	//
	public int removeTrustedEntity(TrustedEntity value, boolean overwrite)
			throws StaleWriteConfigException{
		return this.removeValue(TRUSTED_ENTITY, value, overwrite);
	}

	public TrustedEntity getTrustedEntityById(String id) {
	 if (null != id) { id = id.trim(); }
	TrustedEntity[] o = getTrustedEntity();
	 if (o == null) return null;

	 for (int i=0; i < o.length; i++) {
	     if(o[i].getAttributeValue(Common.convertName(ServerTags.ID)).equals(id)) {
	         return o[i];
	     }
	 }

		return null;
		
	}
	// This attribute is mandatory
	public void setTrustHandler(TrustHandler value) {
		this.setValue(TRUST_HANDLER, value);
		if (value != null) {
			// It's a mutually exclusive property.
			setTrustedEntity(null);
		}
	}

	// Get Method
	public TrustHandler getTrustHandler() {
		return (TrustHandler)this.getValue(TRUST_HANDLER);
	}

	/**
	* Getter for Id of the Element identity-assertion-trust
	* @return  the Id of the Element identity-assertion-trust
	*/
	public String getId() {
		return getAttributeValue(ServerTags.ID);
	}
	/**
	* Modify  the Id of the Element identity-assertion-trust
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setId(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.ID, v, overwrite);
	}
	/**
	* Modify  the Id of the Element identity-assertion-trust
	* @param v the new value
	*/
	public void setId(String v) {
		setAttributeValue(ServerTags.ID, v);
	}
	/**
	* Getter for IsDefault of the Element identity-assertion-trust
	* @return  the IsDefault of the Element identity-assertion-trust
	*/
	public boolean isIsDefault() {
		return toBoolean(getAttributeValue(ServerTags.IS_DEFAULT));
	}
	/**
	* Modify  the IsDefault of the Element identity-assertion-trust
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setIsDefault(boolean v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.IS_DEFAULT, ""+(v==true), overwrite);
	}
	/**
	* Modify  the IsDefault of the Element identity-assertion-trust
	* @param v the new value
	*/
	public void setIsDefault(boolean v) {
		setAttributeValue(ServerTags.IS_DEFAULT, ""+(v==true));
	}
	/**
	* Get the default value of IsDefault from dtd
	*/
	public static String getDefaultIsDefault() {
		return "false".trim();
	}
	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public TrustedEntity newTrustedEntity() {
		return new TrustedEntity();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public TrustHandler newTrustHandler() {
		return new TrustHandler();
	}

	/**
	* get the xpath representation for this element
	* returns something like abc[@name='value'] or abc
	* depending on the type of the bean
	*/
	protected String getRelativeXPath() {
	    String ret = null;
	    ret = "identity-assertion-trust" + (canHaveSiblings() ? "[@id='" + getAttributeValue("id") +"']" : "") ;
	    return (null != ret ? ret.trim() : null);
	}

	/*
	* generic method to get default value from dtd
	*/
	public static String getDefaultAttributeValue(String attr) {
		if(attr == null) return null;
		attr = attr.trim();
		if(attr.equals(ServerTags.IS_DEFAULT)) return "false".trim();
	return null;
	}
	//
	public static void addComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.add(c);
	}

	//
	public static void removeComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.remove(c);
	}
	public void validate() throws org.netbeans.modules.schema2beans.ValidateException {
	}

	// Dump the content of this bean returning it as a String
	public void dump(StringBuffer str, String indent){
		String s;
		Object o;
		org.netbeans.modules.schema2beans.BaseBean n;
		str.append(indent);
		str.append("TrustedEntity["+this.sizeTrustedEntity()+"]");	// NOI18N
		for(int i=0; i<this.sizeTrustedEntity(); i++)
		{
			str.append(indent+"\t");
			str.append("#"+i+":");
			n = (org.netbeans.modules.schema2beans.BaseBean) this.getTrustedEntity(i);
			if (n != null)
				n.dump(str, indent + "\t");	// NOI18N
			else
				str.append(indent+"\tnull");	// NOI18N
			this.dumpAttributes(TRUSTED_ENTITY, i, str, indent);
		}

		str.append(indent);
		str.append("TrustHandler");	// NOI18N
		n = (org.netbeans.modules.schema2beans.BaseBean) this.getTrustHandler();
		if (n != null)
			n.dump(str, indent + "\t");	// NOI18N
		else
			str.append(indent+"\tnull");	// NOI18N
		this.dumpAttributes(TRUST_HANDLER, 0, str, indent);

	}
	public String dumpBeanNode(){
		StringBuffer str = new StringBuffer();
		str.append("IdentityAssertionTrust\n");	// NOI18N
		this.dump(str, "\n  ");	// NOI18N
		return str.toString();
	}}

// END_NOI18N

