/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.enterprise.config.serverbeans;

import org.w3c.dom.*;
import org.netbeans.modules.schema2beans.*;
import java.beans.*;
import java.util.*;
import java.io.Serializable;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.util.i18n.StringManager;

// BEGIN_NOI18N

public class SipService extends ConfigBean implements Serializable
{

	static Vector comparators = new Vector();
	private static final org.netbeans.modules.schema2beans.Version runtimeVersion = new org.netbeans.modules.schema2beans.Version(4, 2, 0);

	static public final String ACCESS_LOG = "AccessLog";
	static public final String SIP_LISTENER = "SipListener";
	static public final String REQUEST_PROCESSING = "RequestProcessing";
	static public final String KEEP_ALIVE = "KeepAlive";
	static public final String CONNECTION_POOL = "ConnectionPool";
	static public final String SIP_PROTOCOL = "SipProtocol";
	static public final String ELEMENT_PROPERTY = "ElementProperty";

	public SipService() {
		this(Common.USE_DEFAULT_VALUES);
	}

	public SipService(int options)
	{
		super(comparators, runtimeVersion);
		// Properties (see root bean comments for the bean graph)
		initPropertyTables(7);
		this.createProperty("access-log", ACCESS_LOG, 
			Common.TYPE_0_1 | Common.TYPE_BEAN | Common.TYPE_KEY, 
			AccessLog.class);
		this.createAttribute(ACCESS_LOG, "format", "Format", 
						AttrProp.CDATA,
						null, "%client.name% %auth-user-name% %datetime% %request% %status% %response.length%");
		this.createAttribute(ACCESS_LOG, "rotation-policy", "RotationPolicy", 
						AttrProp.CDATA,
						null, "time");
		this.createAttribute(ACCESS_LOG, "rotation-interval-in-minutes", "RotationIntervalInMinutes", 
						AttrProp.CDATA,
						null, "1440");
		this.createAttribute(ACCESS_LOG, "rotation-suffix", "RotationSuffix", 
						AttrProp.CDATA,
						null, "yyyyMMdd-HH'h'mm'm'ss's'");
		this.createAttribute(ACCESS_LOG, "rotation-enabled", "RotationEnabled", 
						AttrProp.CDATA,
						null, "true");
		this.createProperty("sip-listener", SIP_LISTENER, 
			Common.TYPE_1_N | Common.TYPE_BEAN | Common.TYPE_KEY, 
			SipListener.class);
		this.createAttribute(SIP_LISTENER, "id", "Id", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.createAttribute(SIP_LISTENER, "address", "Address", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.createAttribute(SIP_LISTENER, "port", "Port", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.createAttribute(SIP_LISTENER, "transport", "Transport", 
						AttrProp.CDATA,
						null, "udp_tcp");
		this.createAttribute(SIP_LISTENER, "enabled", "Enabled", 
						AttrProp.CDATA,
						null, "true");
		this.createProperty("request-processing", REQUEST_PROCESSING, 
			Common.TYPE_0_1 | Common.TYPE_BEAN | Common.TYPE_KEY, 
			RequestProcessing.class);
		this.createAttribute(REQUEST_PROCESSING, "thread-count", "ThreadCount", 
						AttrProp.CDATA,
						null, "128");
		this.createAttribute(REQUEST_PROCESSING, "initial-thread-count", "InitialThreadCount", 
						AttrProp.CDATA,
						null, "48");
		this.createAttribute(REQUEST_PROCESSING, "thread-increment", "ThreadIncrement", 
						AttrProp.CDATA,
						null, "10");
		this.createAttribute(REQUEST_PROCESSING, "request-timeout-in-seconds", "RequestTimeoutInSeconds", 
						AttrProp.CDATA,
						null, "30");
		this.createAttribute(REQUEST_PROCESSING, "header-buffer-length-in-bytes", "HeaderBufferLengthInBytes", 
						AttrProp.CDATA,
						null, "4096");
		this.createProperty("keep-alive", KEEP_ALIVE, 
			Common.TYPE_0_1 | Common.TYPE_BEAN | Common.TYPE_KEY, 
			KeepAlive.class);
		this.createAttribute(KEEP_ALIVE, "thread-count", "ThreadCount", 
						AttrProp.CDATA,
						null, "1");
		this.createAttribute(KEEP_ALIVE, "max-connections", "MaxConnections", 
						AttrProp.CDATA,
						null, "256");
		this.createAttribute(KEEP_ALIVE, "timeout-in-seconds", "TimeoutInSeconds", 
						AttrProp.CDATA,
						null, "30");
		this.createProperty("connection-pool", CONNECTION_POOL, 
			Common.TYPE_0_1 | Common.TYPE_BEAN | Common.TYPE_KEY, 
			ConnectionPool.class);
		this.createAttribute(CONNECTION_POOL, "queue-size-in-bytes", "QueueSizeInBytes", 
						AttrProp.CDATA,
						null, "4096");
		this.createAttribute(CONNECTION_POOL, "max-pending-count", "MaxPendingCount", 
						AttrProp.CDATA,
						null, "4096");
		this.createAttribute(CONNECTION_POOL, "receive-buffer-size-in-bytes", "ReceiveBufferSizeInBytes", 
						AttrProp.CDATA,
						null, "4096");
		this.createAttribute(CONNECTION_POOL, "send-buffer-size-in-bytes", "SendBufferSizeInBytes", 
						AttrProp.CDATA,
						null, "8192");
		this.createProperty("sip-protocol", SIP_PROTOCOL, 
			Common.TYPE_0_1 | Common.TYPE_BEAN | Common.TYPE_KEY, 
			SipProtocol.class);
		this.createAttribute(SIP_PROTOCOL, "error-response-enabled", "ErrorResponseEnabled", 
						AttrProp.CDATA,
						null, "false");
		this.createAttribute(SIP_PROTOCOL, "default-tcp-transport", "DefaultTcpTransport", 
						AttrProp.CDATA,
						null, "false");
		this.createProperty("property", ELEMENT_PROPERTY, 
			Common.TYPE_0_N | Common.TYPE_BEAN | Common.TYPE_KEY, 
			ElementProperty.class);
		this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.initialize(options);
	}

	// Setting the default values of the properties
	void initialize(int options) {

	}

	// This attribute is optional
	public void setAccessLog(AccessLog value) {
		this.setValue(ACCESS_LOG, value);
	}

	// Get Method
	public AccessLog getAccessLog() {
		return (AccessLog)this.getValue(ACCESS_LOG);
	}

	// Get Method
	public SipListener getSipListener(int index) {
		return (SipListener)this.getValue(SIP_LISTENER, index);
	}

	// This attribute is an array containing at least one element
	public void setSipListener(SipListener[] value) {
		this.setValue(SIP_LISTENER, value);
	}

	// Getter Method
	public SipListener[] getSipListener() {
		return (SipListener[])this.getValues(SIP_LISTENER);
	}

	// Return the number of properties
	public int sizeSipListener() {
		return this.size(SIP_LISTENER);
	}

	// Add a new element returning its index in the list
	public int addSipListener(SipListener value)
			throws ConfigException{
		return addSipListener(value, true);
	}

	// Add a new element returning its index in the list with a boolean flag
	public int addSipListener(SipListener value, boolean overwrite)
			throws ConfigException{
		SipListener old = getSipListenerById(value.getId());
		if(old != null) {
			throw new ConfigException(StringManager.getManager(SipService.class).getString("cannotAddDuplicate",  "SipListener"));
		}
		return this.addValue(SIP_LISTENER, value, overwrite);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	//
	public int removeSipListener(SipListener value){
		return this.removeValue(SIP_LISTENER, value);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	// with boolean overwrite
	//
	public int removeSipListener(SipListener value, boolean overwrite)
			throws StaleWriteConfigException{
		return this.removeValue(SIP_LISTENER, value, overwrite);
	}

	public SipListener getSipListenerById(String id) {
	 if (null != id) { id = id.trim(); }
	SipListener[] o = getSipListener();
	 if (o == null) return null;

	 for (int i=0; i < o.length; i++) {
	     if(o[i].getAttributeValue(Common.convertName(ServerTags.ID)).equals(id)) {
	         return o[i];
	     }
	 }

		return null;
		
	}
	// This attribute is optional
	public void setRequestProcessing(RequestProcessing value) {
		this.setValue(REQUEST_PROCESSING, value);
	}

	// Get Method
	public RequestProcessing getRequestProcessing() {
		return (RequestProcessing)this.getValue(REQUEST_PROCESSING);
	}

	// This attribute is optional
	public void setKeepAlive(KeepAlive value) {
		this.setValue(KEEP_ALIVE, value);
	}

	// Get Method
	public KeepAlive getKeepAlive() {
		return (KeepAlive)this.getValue(KEEP_ALIVE);
	}

	// This attribute is optional
	public void setConnectionPool(ConnectionPool value) {
		this.setValue(CONNECTION_POOL, value);
	}

	// Get Method
	public ConnectionPool getConnectionPool() {
		return (ConnectionPool)this.getValue(CONNECTION_POOL);
	}

	// This attribute is optional
	public void setSipProtocol(SipProtocol value) {
		this.setValue(SIP_PROTOCOL, value);
	}

	// Get Method
	public SipProtocol getSipProtocol() {
		return (SipProtocol)this.getValue(SIP_PROTOCOL);
	}

	// Get Method
	public ElementProperty getElementProperty(int index) {
		return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
	}

	// This attribute is an array, possibly empty
	public void setElementProperty(ElementProperty[] value) {
		this.setValue(ELEMENT_PROPERTY, value);
	}

	// Getter Method
	public ElementProperty[] getElementProperty() {
		return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
	}

	// Return the number of properties
	public int sizeElementProperty() {
		return this.size(ELEMENT_PROPERTY);
	}

	// Add a new element returning its index in the list
	public int addElementProperty(ElementProperty value)
			throws ConfigException{
		return addElementProperty(value, true);
	}

	// Add a new element returning its index in the list with a boolean flag
	public int addElementProperty(ElementProperty value, boolean overwrite)
			throws ConfigException{
		ElementProperty old = getElementPropertyByName(value.getName());
		if(old != null) {
			throw new ConfigException(StringManager.getManager(SipService.class).getString("cannotAddDuplicate",  "ElementProperty"));
		}
		return this.addValue(ELEMENT_PROPERTY, value, overwrite);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	//
	public int removeElementProperty(ElementProperty value){
		return this.removeValue(ELEMENT_PROPERTY, value);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	// with boolean overwrite
	//
	public int removeElementProperty(ElementProperty value, boolean overwrite)
			throws StaleWriteConfigException{
		return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
	}

	public ElementProperty getElementPropertyByName(String id) {
	 if (null != id) { id = id.trim(); }
	ElementProperty[] o = getElementProperty();
	 if (o == null) return null;

	 for (int i=0; i < o.length; i++) {
	     if(o[i].getAttributeValue(Common.convertName(ServerTags.NAME)).equals(id)) {
	         return o[i];
	     }
	 }

		return null;
		
	}
	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public AccessLog newAccessLog() {
		return new AccessLog();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public SipListener newSipListener() {
		return new SipListener();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public RequestProcessing newRequestProcessing() {
		return new RequestProcessing();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public KeepAlive newKeepAlive() {
		return new KeepAlive();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public ConnectionPool newConnectionPool() {
		return new ConnectionPool();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public SipProtocol newSipProtocol() {
		return new SipProtocol();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public ElementProperty newElementProperty() {
		return new ElementProperty();
	}

	/**
	* get the xpath representation for this element
	* returns something like abc[@name='value'] or abc
	* depending on the type of the bean
	*/
	protected String getRelativeXPath() {
	    String ret = null;
	    ret = "sip-service";
	    return (null != ret ? ret.trim() : null);
	}

	/*
	* generic method to get default value from dtd
	*/
	public static String getDefaultAttributeValue(String attr) {
		if(attr == null) return null;
		attr = attr.trim();
	return null;
	}
	//
	public static void addComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.add(c);
	}

	//
	public static void removeComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.remove(c);
	}
	public void validate() throws org.netbeans.modules.schema2beans.ValidateException {
	}

	// Dump the content of this bean returning it as a String
	public void dump(StringBuffer str, String indent){
		String s;
		Object o;
		org.netbeans.modules.schema2beans.BaseBean n;
		str.append(indent);
		str.append("AccessLog");	// NOI18N
		n = (org.netbeans.modules.schema2beans.BaseBean) this.getAccessLog();
		if (n != null)
			n.dump(str, indent + "\t");	// NOI18N
		else
			str.append(indent+"\tnull");	// NOI18N
		this.dumpAttributes(ACCESS_LOG, 0, str, indent);

		str.append(indent);
		str.append("SipListener["+this.sizeSipListener()+"]");	// NOI18N
		for(int i=0; i<this.sizeSipListener(); i++)
		{
			str.append(indent+"\t");
			str.append("#"+i+":");
			n = (org.netbeans.modules.schema2beans.BaseBean) this.getSipListener(i);
			if (n != null)
				n.dump(str, indent + "\t");	// NOI18N
			else
				str.append(indent+"\tnull");	// NOI18N
			this.dumpAttributes(SIP_LISTENER, i, str, indent);
		}

		str.append(indent);
		str.append("RequestProcessing");	// NOI18N
		n = (org.netbeans.modules.schema2beans.BaseBean) this.getRequestProcessing();
		if (n != null)
			n.dump(str, indent + "\t");	// NOI18N
		else
			str.append(indent+"\tnull");	// NOI18N
		this.dumpAttributes(REQUEST_PROCESSING, 0, str, indent);

		str.append(indent);
		str.append("KeepAlive");	// NOI18N
		n = (org.netbeans.modules.schema2beans.BaseBean) this.getKeepAlive();
		if (n != null)
			n.dump(str, indent + "\t");	// NOI18N
		else
			str.append(indent+"\tnull");	// NOI18N
		this.dumpAttributes(KEEP_ALIVE, 0, str, indent);

		str.append(indent);
		str.append("ConnectionPool");	// NOI18N
		n = (org.netbeans.modules.schema2beans.BaseBean) this.getConnectionPool();
		if (n != null)
			n.dump(str, indent + "\t");	// NOI18N
		else
			str.append(indent+"\tnull");	// NOI18N
		this.dumpAttributes(CONNECTION_POOL, 0, str, indent);

		str.append(indent);
		str.append("SipProtocol");	// NOI18N
		n = (org.netbeans.modules.schema2beans.BaseBean) this.getSipProtocol();
		if (n != null)
			n.dump(str, indent + "\t");	// NOI18N
		else
			str.append(indent+"\tnull");	// NOI18N
		this.dumpAttributes(SIP_PROTOCOL, 0, str, indent);

		str.append(indent);
		str.append("ElementProperty["+this.sizeElementProperty()+"]");	// NOI18N
		for(int i=0; i<this.sizeElementProperty(); i++)
		{
			str.append(indent+"\t");
			str.append("#"+i+":");
			n = (org.netbeans.modules.schema2beans.BaseBean) this.getElementProperty(i);
			if (n != null)
				n.dump(str, indent + "\t");	// NOI18N
			else
				str.append(indent+"\tnull");	// NOI18N
			this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
		}

	}
	public String dumpBeanNode(){
		StringBuffer str = new StringBuffer();
		str.append("SipService\n");	// NOI18N
		this.dump(str, "\n  ");	// NOI18N
		return str.toString();
	}}

// END_NOI18N

