/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.admin;

import com.sun.enterprise.util.SystemPropertyConstants;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

import java.io.*;
import java.util.logging.Logger;
import java.util.logging.Level;

import javax.xml.bind.*;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;


/**
 * This object contains factory methods for each
 * Java content interface and Java element interface
 * generated in the org.jvnet.glassfish.comms.clb.admin package.
 * <p>An ObjectFactory allows you to programatically
 * construct new instances of the Java representation
 * for XML content. The Java representation of XML
 * content can consist of schema derived interfaces
 * and classes representing the binding of schema
 * type definitions, element declarations and model
 * groups.  Factory methods for each of these are
 * provided in this class.
 *
 */
@XmlRegistry
public class ObjectFactory {
    static final String CLB_DOCTYPE = "<!DOCTYPE loadbalancer PUBLIC \"-//Sun Microsystems Inc.//DTD Sun Java System Application Server 9.1//EN\" \"http://www.sun.com/software/appserver/dtds/sun-converged-loadbalancer_1_0.dtd\">";
    static final String CLB_XML_ENCODING = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: org.jvnet.glassfish.comms.clb.admin
     *
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link WebModule }
     *
     */
    public WebModule createWebModule() {
        return new WebModule();
    }

    /**
     * Create an instance of {@link Instance }
     *
     */
    public Instance createInstance() {
        return new Instance();
    }

    /**
     * Create an instance of {@link Loadbalancer }
     *
     */
    public Loadbalancer createLoadbalancer() {
        return new Loadbalancer();
    }

    /**
     * Create an instance of {@link Cluster }
     *
     */
    public Cluster createCluster() {
        return new Cluster();
    }

    /**
     * Create an instance of {@link Property }
     *
     */
    public Property createProperty() {
        return new Property();
    }

    /**
      * Method to load the configration from the inputStream
      *@param in - InputStream to the lb configuration
      *@throws DOMException
     *        ParserConfigurationException
     *        IOException
     *        SAXException if error occurs during parsing or unmarshalling
     */
    public Loadbalancer load(InputStream in)
        throws JAXBException, DOMException, ParserConfigurationException,
            IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);

        DocumentBuilder db = dbf.newDocumentBuilder();
        ErrorHandler errorHandler = new ErrorHandler();
        db.setErrorHandler(errorHandler);
        db.setEntityResolver(errorHandler);

        Document doc = db.parse(in);

        JAXBContext context = JAXBContext.newInstance(
                "org.jvnet.glassfish.comms.clb.admin");
        Unmarshaller unmarshaller = context.createUnmarshaller();

        Loadbalancer lb = (Loadbalancer) unmarshaller.unmarshal(doc);

        return lb;
    }

    /**
      * Method to store the configration to the specified outputStream
      *@param os - InputStream to the lb configuration
      *@throws JAXBException and IOException if error occurs during marshalling
     */
    public void store(Loadbalancer lb, OutputStream os)
        throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance(
                "org.jvnet.glassfish.comms.clb.admin");
        Marshaller marshaller = context.createMarshaller();
        //Turn on the option to format the XML
        marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
        //Need to custom XML Declarations. Hence turn off the default option
        marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", Boolean.FALSE);

        //Write out the custom XML encoding and doctype
        os.write(CLB_XML_ENCODING.getBytes());

        final String lineSeperator = System.getProperty("line.separator");
        os.write((lineSeperator != null) ? lineSeperator.getBytes()
                                         : "\\n".getBytes());
        os.write(CLB_DOCTYPE.getBytes());

        marshaller.marshal(lb, os);
    }
}


class ErrorHandler extends DefaultHandler {
    static final String CLB_DTD_FILE = "lib" + File.separator + "dtds" +
        File.separator + "sun-converged-loadbalancer_1_0.dtd";
    Logger logger = org.jvnet.glassfish.comms.util.LogUtil.CLB_LOGGER.getLogger();

    public InputSource resolveEntity(String publicId, String systemId)
        throws SAXException, IOException {
        logger.log(Level.INFO, "System id " + systemId);

        final String installDir = System.getProperty(SystemPropertyConstants.INSTALL_ROOT_PROPERTY);
        String customSystemId = installDir + File.separator + CLB_DTD_FILE;
        logger.log(Level.INFO,"Substituting System id to " + customSystemId);

        InputSource is = new InputSource(new FileInputStream(
                    new File(customSystemId)));

        logger.log(Level.INFO,"InputStream is null? " + Boolean.toString(is == null));

        return is;
    }

    public void error(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage());
    }
}
