/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.deployment.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;

import javax.servlet.ServletContextListener;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.TimerListener;

import org.apache.catalina.Context;




public class SipApplicationListeners {
	
    private static final Logger logger = Logger.getLogger("SipContainer");

    /**
     * A SipApplicationSession has been created, destroyed, or has timed out.
     */
    private ArrayList<SipApplicationSessionListener> sipApplicationSessionListeners =
        new ArrayList<SipApplicationSessionListener>();

    /**
     * A SipSession has been created or destroyed.
     */
    private ArrayList<SipSessionListener> sipSessionListeners = new ArrayList<SipSessionListener>();

    /**
     * Attributes on the servlet context have been added, removed or replaced.
     */
    private ArrayList<SipSessionAttributeListener> sipSessionAttributeListeners = new ArrayList<SipSessionAttributeListener>();

    /**
     * notification that an expected ACK or PRACK was not received.
     */
    private ArrayList<SipErrorListener> sipErrorListeners = new ArrayList<SipErrorListener>();

    /**
     * Timer listener for this application
     */
    private TimerListener timerListener = null;

    
    /**
     * ServletContext listener for this application
     */
    private ArrayList<ServletContextListener> servletContextListener = new ArrayList<ServletContextListener>();
    private ArrayList<String> sipServletsWithListeners = new ArrayList<String>();

    
    private ArrayList<SipServletListener> sipServletListener = new ArrayList<SipServletListener>();
    

    /* Set of all listener instances, used for injection */
    private Set<Object> instances = new HashSet<Object>();
    

    
    /**
     * This will build and manage a list of session listeners for a given Sip
     * Application
     *
     * @param listenerList
     *        A collection of class name
     * @param classLoader
     *        The class loader to use to instantiate the listeners
     */
    public SipApplicationListeners(Collection<String> listenerList,
        ClassLoader classLoader ) {
    	
        
        // Instantiate all the listeners
        Iterator<String> itr = listenerList.iterator();

        while (itr.hasNext()) {
            String className = (String) itr.next();

            try {
                Object listener = classLoader.loadClass(className).newInstance();
                
                instances.add(listener);
                
                if (listener instanceof SipServlet) {
                    sipServletsWithListeners.add(className);

                    continue;
                }
                
                if (listener instanceof SipServletListener) {
                    addSipServletListener((SipServletListener) listener);
                }
                
                
                if (listener instanceof SipApplicationSessionListener) {
                    addSipApplicationSessionListener((SipApplicationSessionListener) listener);
                }

                if (listener instanceof SipSessionListener) {
                    addSipSessionListener((SipSessionListener) listener);
                }

                if (listener instanceof SipSessionAttributeListener) {
                    addSipSessionAttributeListener((SipSessionAttributeListener) listener);
                }

                if (listener instanceof TimerListener) {
                    setTimerListener((TimerListener) listener);
                }

                if (listener instanceof SipErrorListener) {
                    addSipErrorListener((SipErrorListener) listener);
                }

                if (listener instanceof ServletContextListener) {
                    addServletContextListener((ServletContextListener) listener);
                }
            } catch (Exception e) {
                logger.log(Level.SEVERE,
                    "Cannot instantiate listener class " + className, e);
            }
        }
    }

    public Set<Object> getListenerInstances() {
      return instances;
    }


    
    public ArrayList<String> getSipServletsWithListeners() {
        return sipServletsWithListeners;
    }

    /**
     * @return Returns the sipApplicationSessionListeners.
     */
    public ArrayList<SipApplicationSessionListener> getSipApplicationSessionListeners() {
        return sipApplicationSessionListeners;
    }

    /**
     * Add a Sip Application Session Listener
     * @param listener
     */
    public void addSipApplicationSessionListener(
        SipApplicationSessionListener listener) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE,
                "registering SipApplicationSessionListener: " +
                listener.getClass().getName());
        }
        
        sipApplicationSessionListeners.add(listener);
    }

    /**
     * @return Returns the sipSessionAttributeListeners.
     */
    public ArrayList<SipSessionAttributeListener> getSipSessionAttributeListeners() {
        return sipSessionAttributeListeners;
    }

    /**
     * Add a sip session attribute listener
     * @param listener
     */
    public void addSipSessionAttributeListener(
        SipSessionAttributeListener listener) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE,
                "registering SipSessionAttributeListener: " +
                listener.getClass().getName());
        }

        sipSessionAttributeListeners.add(listener);
    }

    /**
     * @return Returns the sipSessionListeners.
     */
    public ArrayList<SipSessionListener> getSipSessionListeners() {
        return sipSessionListeners;
    }

    /**
     * Add a sip session listener
     * @param listener
     */
    public void addSipSessionListener(SipSessionListener listener) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE,
                "registering SipSessionListener: " +
                listener.getClass().getName());
        }

        sipSessionListeners.add(listener);
    }

    /**
     * @return Returns the timer listener.
     */
    public TimerListener getTimerListener() {
        return timerListener;
    }

    /**
     * Add a timer listener
     * @param listener
     */
    public void setTimerListener(TimerListener listener) {
        if (timerListener != null) {
            logger.log(Level.WARNING,
                "ignoring TimerListener: " + listener.getClass().getName());

            return;
        }

        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE,
                "registering TimerListener: " + listener.getClass().getName());
        }

        timerListener = listener;
    }

    /**
     * @return Returns the sip error listeners.
     */
    public ArrayList<SipErrorListener> getSipErrorListeners() {
        return sipErrorListeners;
    }

    /**
     * Add a sip error listener
     * @param listener
     */
    public void addSipErrorListener(SipErrorListener listener) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE,
                "registering SipErrorListener: " +
                listener.getClass().getName());
        }

        sipErrorListeners.add(listener);
    }

    /**
     * Add a ServletContextListener to list.
     * @param listener The listener to add.
     */
    public void addServletContextListener(ServletContextListener listener) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE,
                "registering ServletContextListener: " +
                listener.getClass().getName());
        }

        servletContextListener.add(listener);
    }

    /**
     * The method will return an ArrayList of the registered ServletContextListener.
     * @return A list with the all context Listener.
     */
    public ArrayList<ServletContextListener> getServletContextListener() {
        return servletContextListener;
    }

    
    /**
     * Add a ServletContextListener to list.
     * @param listener The listener to add.
     */
    public void addSipServletListener(SipServletListener listener) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE,
                "registering SipServletListener: " +
                listener.getClass().getName());
        }

        sipServletListener.add(listener);
    }

    /**
     * The method will return an ArrayList of the registered ServletContextListener.
     * @return A list with the all context Listener.
     */
    public ArrayList<SipServletListener> getSipServletListener() {
        return sipServletListener;
    }
    
    
    
    /**
     * Empty vectors to allow garbage collectiont
     */
    public void clean() {
        sipApplicationSessionListeners.clear();
        sipSessionListeners.clear();
        sipSessionAttributeListeners.clear();
        sipErrorListeners.clear();
        servletContextListener.clear();
        sipServletListener.clear();
        timerListener = null;
        instances.clear();
    }
}
