/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/*
 * SipBundleDescriptor.java
 *
 * This class represents the BundleDescriptor for pure SIP and Converged
 * HTTP and SIP applications.
 * Created on February 27, 2007, 3:17 PM
 *
 */
package org.jvnet.glassfish.comms.deployment.backend;

import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.interfaces.pluggable.ArchiveDescriptor;
import com.sun.enterprise.deployment.runtime.web.SessionConfig;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.WebBundleVisitor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.loader.EJBClassLoader;


import org.jvnet.glassfish.comms.deployment.runtime.sip.SunSipApp;

import com.sun.enterprise.deployment.runtime.web.Servlet;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.deployment.runtime.common.PrincipalNameDescriptor;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;

import java.security.Principal;
import java.util.Iterator;
import java.util.List;

import java.util.Set;
import java.util.HashSet;
import java.util.HashMap;
import javax.enterprise.deploy.shared.ModuleType;


/**
 *
 * @author  Prasad Subramanian
 */
public class SipBundleDescriptor extends WebBundleDescriptor
         implements ArchiveDescriptor {
    
    private SipApplication sipApplication = null;
    private boolean isConverged = false;
    //private SunSipApp sunSipApp = null;
    private ModuleType moduleType =  XModuleType.getModuleType(
            "org.jvnet.glassfish.comms.deployment.backend.SipArchiveDeployer");
    private HashMap<String, String> runAsMap = null;


    private String moduleName = null;
    
    private Set<ResourceReferenceDescriptor> convergedResRefDescSet = 
            new HashSet<ResourceReferenceDescriptor>();

    private Set<EjbReferenceDescriptor> convergedEjbRefDescSet = 
            new HashSet<EjbReferenceDescriptor>();

    private Set<JmsDestinationReferenceDescriptor>
            convergedJmsDestRefDescSet = new HashSet<JmsDestinationReferenceDescriptor>();

    /** Creates a new instance of SipBundleDescriptor */
    public SipBundleDescriptor() {
    }

    /**
     * Returns the classloader for the module
     * @return ClassLoader
     */
    public ClassLoader getModuleClassLoader() {
        return new EJBClassLoader();
    }

    /**
     * Sets the SipApplication object. This method is useful when we want to
     * add a SipApplication after processing the sip.xml
     * @param sipApplication the SipApplication object that holds the meta data
     *                       from the processed sip.xml
     */
    public void setSipApplication(SipApplication sipApplication) {
        this.sipApplication = sipApplication;
    }

    /**
     * Returns the SipApplication object for the module
     * @return a SipApplication object that represents the sip.xml meta data
     */
    public SipApplication getSipApplication() {
        return sipApplication;
    }

    /**
     * Returns the module type for the module that the SipBundleDescriptor
     * describes/
     * @return a ModuleType object representing the module type
     */
    public ModuleType getModuleType() {
        return moduleType;
    }

    /** 
     * Allow the SipVerifier to set the moduleType to WAR
     * while it invokes WebVerifier.
     */
    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public void setConverged(boolean isConverged) {
        this.isConverged = isConverged;
    }

    public boolean isConverged() {
        return isConverged;
    }

   /* public void setSunSipDescriptor(SunSipApp sunSipApp) {
        this.sunSipApp = sunSipApp;
    }

    public SunSipApp getSunSipDescriptor() {
        if (sunSipApp == null) {
            sunSipApp = new SunSipApp();
        }

        return sunSipApp;
    } */

    /**
     * Gets the session configuration information from sun-sip.xml.
     *
     * @return The session configuration information from sun-sip.xml
     */
    public SessionConfig getSunSipSessionConfig() {
        return getSipApplication().getSunSipDescriptor().getSessionConfig();
    }
    
    public String getModuleName() {
        return moduleName;
    }
    
    public Object getReferringDescriptor() {
        return null;
    }
    
    public void visit(ComponentVisitor cVisitor) {
        super.visit((WebBundleVisitor) cVisitor);
        this.getSipApplication().visit((WebBundleVisitor) cVisitor);
    }
    
    /**
     * This method returns the super-set of the ResourceReferenceDescriptors
     * from both the sip.xml and web.xml
     * @return Set of ResourceReferenceDescriptors
     */
    public Set getResourceReferenceDescriptors() {
        
        if(convergedResRefDescSet.isEmpty() &&
                sipApplication == null ) {
            // return the set from web bundle desc as we may not have 
            // parsed the sip.xml yet
            return super.getResourceReferenceDescriptors();
            
        } else if(convergedResRefDescSet.isEmpty() &&
                sipApplication != null ) {
            try {
                convergedResRefDescSet.
                    addAll(sipApplication.getResourceReferenceDescriptors());
                convergedResRefDescSet.
                    addAll(super.getResourceReferenceDescriptors());          
            } catch(Exception e) {
                // log exception
                e.printStackTrace();
                return convergedResRefDescSet;
            }
        } 
        return convergedResRefDescSet;
    }
    
    /**
     * This method returns the super-set of the EjbReferenceDescriptors
     * from both the sip.xml and web.xml
     * @return Set of EjbReferenceDescriptors
     */
    public Set getEjbReferenceDescriptors() {
        
        if(convergedEjbRefDescSet.isEmpty() &&
                sipApplication == null ) {
            // return the set from web bundle desc as we may not have 
            // parsed the sip.xml yet
            return super.getEjbReferenceDescriptors();
            
        } else if(convergedEjbRefDescSet.isEmpty() &&
                sipApplication != null ) {
            try {
                convergedEjbRefDescSet.
                    addAll(sipApplication.getEjbReferenceDescriptors());
                convergedEjbRefDescSet.
                    addAll(super.getEjbReferenceDescriptors());          
            } catch(Exception e) {
                // log exception
                e.printStackTrace();
                return convergedEjbRefDescSet;
            }
        } 
        return convergedEjbRefDescSet;
    }
    
    /**
     * This method returns the super-set of the JmsDestinataionReferenceDescriptors
     * from both the sip.xml and web.xml
     * @return Set of JmsDestinationReferenceDescriptors
     */
    public Set getJmsDestReferenceDescriptors() {
        
        if(convergedJmsDestRefDescSet.isEmpty() &&
                sipApplication == null ) {
            // return the set from web bundle desc as we may not have 
            // parsed the sip.xml yet
            return super.getJmsDestinationReferenceDescriptors();
            
        } else if(convergedJmsDestRefDescSet.isEmpty() &&
                sipApplication != null ) {
            try {
                convergedJmsDestRefDescSet.
                    addAll(sipApplication.getJmsDestinationReferenceDescriptors());
                convergedJmsDestRefDescSet.
                    addAll(super.getJmsDestinationReferenceDescriptors());          
            } catch(Exception e) {
                // log exception
                e.printStackTrace();
                return convergedJmsDestRefDescSet;
            }
        } 
        return convergedJmsDestRefDescSet;
    }


    public Iterator<String> getServletsWithRunAs(){
        if(runAsMap == null){
            runAsMap = new HashMap<String,String>();
            readRunAs();
        }
        return runAsMap.keySet().iterator();
    }

    public String getRunAsPrincipal(String servletName){
        if(runAsMap == null){
            runAsMap = new HashMap<String,String>();
            readRunAs();
        }
        return runAsMap.get(servletName);
    }

    private void readRunAs() {
        Servlet[] servlets = getSipApplication().getSunSipDescriptor().getServlet();
        if (servlets != null) {
            for (int i = 0; i < servlets.length; i++) {
                Servlet servlet = servlets[i];
                String prinName = servlet.getPrincipalName();
                String sn = servlet.getServletName();
                runAsMap.put(sn, prinName);
            }
        } else {
            SecurityRoleMapping[] srmList =  getSipApplication().getSunSipDescriptor().getSecurityRoleMapping();
            SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryMgr.getFactory();
            Iterator<String> itr = sipApplication.getServletNames();
            while (itr.hasNext()) {
                String servletName = itr.next();
                String roleName = sipApplication.getRunAsRoleName(servletName);
                if (roleName != null && roleName.length() > 0) {
                    for (int si = 0; si < srmList.length; si++) {
                        SecurityRoleMapping srm = srmList[si];
                        String role = srm.getRoleName();
                        if (role != null && role.equals(roleName)) {
                            List<PrincipalNameDescriptor> principals = srm.getPrincipalNames();
                            if (principals.size() > 0) {
                                Principal principal = principals.get(0).getPrincipal();
                                runAsMap.put(servletName, principal.getName());
                                break;
                            }
                        }
                    }
                }
            }
        }
     }
}
