/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.deployment.node.sip;

import com.sun.enterprise.deployment.xml.WebTagNames;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Map;

import java.util.logging.Level;
import org.jvnet.glassfish.comms.deployment.backend.Condition;
import org.jvnet.glassfish.comms.deployment.backend.ContainsOperand;

import org.jvnet.glassfish.comms.deployment.backend.ServletMapping;
import org.jvnet.glassfish.comms.deployment.backend.Pattern;
import org.jvnet.glassfish.comms.deployment.backend.EqualOperand;
import org.jvnet.glassfish.comms.deployment.backend.Operator;
import org.jvnet.glassfish.comms.deployment.util.SipTagNames;


/**
 * This node is responsible for handling servlet-mapping subtree node
 *
 * @author  Prasad Subramanian
 * @version 
 */
public class ContainsOperandNode extends OperandNode {

    private Object descriptor;
    
    private static LocalStringManagerImpl localStrings =
            new LocalStringManagerImpl(ContainsOperandNode.class);
    private final static XMLElement tag = 
        new XMLElement(SipTagNames.CONTAINS);    
    
    public ContainsOperandNode(){
        super();
    }

   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        if (descriptor==null) {
            descriptor = 
                (ContainsOperand)DescriptorFactory.getDescriptor(getXMLPath());
        }
        return descriptor;
    }
    
   /**
     * parsed an attribute of an element
     *
     * @param the element name
     * @param the attribute name
     * @param the attribute value
     * @return true if the attribute was processed
     */
    public boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
        if (attributeName.getQName().equals(SipTagNames.IGNORE_CASE)) {
            ((ContainsOperand)getDescriptor()).setIgnoreCase(value);
            return true;
        }
	return false;
    }
    
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {
        // no need to be synchronized for now
        Map table = super.getDispatchTable();
        table.put(SipTagNames.VALUE, "setValue"); 
        table.put(SipTagNames.VAR, "setVariable");        
        return table;
    }    
    
    /** 
     * receives notification of the end of an XML element by the Parser
     * 
     * @param element the xml tag identification
     * @return true if this node is done processing the XML sub tree
     */
    public boolean endElement(XMLElement element) {
	//DOLUtils.getDefaultLogger().finer("ENDELEMENT : " + "in " + getXMLRootTag() + "  Node, endElement " + element.getQName());
        boolean allDone = element.equals(getXMLRootTag());
        if (allDone) {
            if (getParentNode()!=null && getDescriptor()!=null) {
                if(getParentNode() instanceof OperatorNode ) {
                    ((Operator)getParentNode().getDescriptor()).
                            addCondition((Condition) this.getDescriptor());
                } else if(getParentNode() instanceof PatternNode) {
                    ((Pattern)getParentNode().getDescriptor()).
                            addCondition((Condition)this.getDescriptor());                    
                }
            }      
        } 
        return allDone;
    }
    
    /**
     * @return the XML tag associated with this XMLNode
     */
    protected XMLElement getXMLRootTag() {
        return tag;
    }    
}
