/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.deployment.node.sip;


import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.node.web.InitParamNode;
import com.sun.enterprise.deployment.node.web.ListenerNode;
import com.sun.enterprise.deployment.web.SecurityRole;
import java.util.*;
import org.jvnet.glassfish.comms.deployment.backend.SecurityConstraint;
import org.jvnet.glassfish.comms.deployment.backend.Servlet;
import org.jvnet.glassfish.comms.deployment.backend.ServletMapping;
import org.jvnet.glassfish.comms.deployment.backend.SipBundleDescriptor;

import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.*;
import com.sun.enterprise.deployment.node.web.LoginConfigNode;


import com.sun.enterprise.deployment.xml.TagNames;
import com.sun.enterprise.deployment.xml.WebTagNames;
import com.sun.enterprise.deployment.xml.WebServicesTagNames;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;

import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.AppListenerDescriptorImpl;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.LoginConfigurationImpl;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DOLLoadingContextFactory;
import com.sun.enterprise.deployment.web.LoginConfiguration;


import org.jvnet.glassfish.comms.deployment.backend.SipApplication;

import org.jvnet.glassfish.comms.deployment.node.sip.NotOperatorNode;
import org.jvnet.glassfish.comms.deployment.node.sip.SecurityConstraintsNode;

import org.jvnet.glassfish.comms.deployment.util.SipTagNames;

/**
 * This node is responsible for handling the sip-app xml tree
 *
 * @author  Prasad Subramanian
 * @version 
 */
public class SipBundleNode extends BundleNode implements RootXMLNode {

   public final static XMLElement tag = new XMLElement(SipTagNames.SIP_BUNDLE);

    /** 
     * The public ID for my documents.
     */
    public final static String PUBLIC_DTD_ID =  "-//Java Community Process//DTD SIP Application 1.0//EN";
    
    /** 
     * The system ID of my documents. 
     */
    public final static String SYSTEM_ID = "http://www.jcp.org/dtd/sip-app_1_0.dtd";
    
    
    public final static String SCHEMA_ID = "sip-app_1_1.xsd";
    public final static String SPEC_VERSION = "1.1";
    private final static List<String> systemIDs = initSystemIDs();

    private static List<String> initSystemIDs() {
        List<String> systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        return Collections.unmodifiableList(systemIDs);
    }
    
    private SipBundleDescriptor descriptor;
    private Map servletMappings;
    
   /**
    * register this node as a root node capable of loading entire DD files
    * 
    * @param publicIDToDTD is a mapping between xml Public-ID to DTD 
    * @return the doctype tag name
    */    
    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        return tag.getQName();
    }
    
    /** Creates new SipBundleNode */
    public SipBundleNode(Descriptor sbd)  {
        super();
        this.descriptor = (SipBundleDescriptor)sbd;
        registerElementHandler(new XMLElement(WebTagNames.ICON), 
                IconNode.class);
        registerElementHandler(new XMLElement(SipTagNames.SERVLET), 
                SipServletNode.class);       
        registerElementHandler(new XMLElement(SipTagNames.SERVLET_MAPPING), 
                SipServletMappingNode.class);
        registerElementHandler(new XMLElement(SipTagNames.SESSION_CONFIG), 
                SessionConfigNode.class);
        registerElementHandler(new XMLElement(SipTagNames.PROXY_CONFIG), 
                ProxyConfigNode.class);
        registerElementHandler(new XMLElement(WebTagNames.CONTEXT_PARAM), 
                InitParamNode.class, "addContextParameter");        
        registerElementHandler(new XMLElement(TagNames.ENVIRONMENT_PROPERTY), 
                EnvEntryNode.class);                          
        registerElementHandler(new XMLElement(TagNames.EJB_REFERENCE), 
                EjbReferenceNode.class );     
        registerElementHandler(new XMLElement(TagNames.EJB_LOCAL_REFERENCE), 
                EjbLocalReferenceNode.class);     
        registerElementHandler(new XMLElement(TagNames.RESOURCE_REFERENCE), 
                ResourceRefNode.class, "addResourceReferenceDescriptor");   
        registerElementHandler(new XMLElement(TagNames.RESOURCE_ENV_REFERENCE), 
                ResourceEnvRefNode.class, "addJmsDestinationReferenceDescriptor");               
        registerElementHandler(new XMLElement(WebTagNames.SECURITY_CONSTRAINT),         
                SecurityConstraintsNode.class);                
        registerElementHandler(new XMLElement(WebTagNames.LOGIN_CONFIG), 
                LoginConfigNode.class);   
        registerElementHandler(new XMLElement(TagNames.ROLE), 
                SecurityRoleNode.class);        
        registerElementHandler(new XMLElement(TagNames.POST_CONSTRUCT), 
                LifecycleCallbackNode.class, "addPostConstructDescriptor");
        registerElementHandler(new XMLElement(TagNames.PRE_DESTROY), 
                LifecycleCallbackNode.class, "addPreDestroyDescriptor");
    }
    
   /**
    * @return the descriptor instance to associate with this XMLNode
    */
    public Object getDescriptor() {
        SipApplication sipApp = descriptor.getSipApplication();
        if(sipApp == null ) {
            sipApp = new SipApplication();
            descriptor.setSipApplication(sipApp);
        }
        return sipApp;
    }  
    
    /**
     * Adds  a new DOL descriptor instance to the descriptor instance associated with 
     * this XMLNode
     *
     * @param descriptor the new descriptor
     */    
    public void addDescriptor(Object  newDescriptor) {       
        if (newDescriptor instanceof EjbReference) {            
            descriptor.getSipApplication().addEjbReferenceDescriptor(
                        (EjbReferenceDescriptor) newDescriptor);
        } else  if (newDescriptor instanceof EnvironmentProperty) {
           descriptor.getSipApplication().
                   addEnvironmentProperty((EnvironmentProperty) newDescriptor);
        } else if (newDescriptor instanceof LoginConfiguration) {
            if ((LoginConfiguration)descriptor.
                    getSipApplication().getLoginConfiguration()!=null) {
                throw new RuntimeException(
                    "Has more than one login-config element!");
            }
            descriptor.getSipApplication().setLoginConfiguration(
                (LoginConfiguration)newDescriptor);
        } else if(newDescriptor instanceof Servlet) {
            descriptor.getSipApplication().addServlet((Servlet)newDescriptor);
        } else if(newDescriptor instanceof ServletMapping) {
            descriptor.getSipApplication().addServletMapping(
                    (ServletMapping)newDescriptor);
        } else if(newDescriptor instanceof SecurityConstraint) {
            descriptor.getSipApplication().addSecurityConstraint(
                    (SecurityConstraint)newDescriptor);
        } else if(newDescriptor instanceof SecurityRole) {
            descriptor.getSipApplication().addSecurityRole(
                    (SecurityRole)newDescriptor);
        }

    }       
    
    /**
     * receives notiification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */    
    public void setElementValue(XMLElement element, String value) {    
        if (WebTagNames.SESSION_TIMEOUT.equals(element.getQName())) {
            // if the session out value is already set
            // which means there are multiple session-config elements
            // throw an exception
            if (descriptor.getSessionTimeout() != 
                WebBundleDescriptor.SESSION_TIMEOUT_DEFAULT) {
                throw new RuntimeException(
                    "Has more than one session-config element!");
            } 
            descriptor.setSessionTimeout((Integer.valueOf(value.trim())).intValue());
        } else {
            super.setElementValue(element, value);
        }
    }     

    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {
        // no need to be synchronized for now
        Map table = super.getDispatchTable();
        table.put(SipTagNames.DISPLAY_NAME, "setDisplayName");
        table.put(SipTagNames.DESCRIPTION, "setDescription");
        table.put(SipTagNames.DISTRIBUTABLE, "setDistributable");
        table.put(SipTagNames.APP_NAME, "setAppName");
        table.put(WebTagNames.LISTENER_CLASS, "addListener");
        return table;
    }
    
   /**
     * @return the XML tag associated with this XMLNode
     */
    protected XMLElement getXMLRootTag() {
        return tag;
    }       

    /**
     * @return the DOCTYPE of the XML file
     */
    public String getDocType() {
        return null;
    }
    
    /**
     * @return the SystemID of the XML file
     */
    public String getSystemID() {
        return SCHEMA_ID;
    }

    /**
     * @return the list of SystemID of the XML schema supported
     */
    public List<String> getSystemIDs() {
        return systemIDs;
    }
    
    /**
     * add a servelt mapping for one of the servlet of this bundle
     * 
     * @param servletName the servlet the mapping applies to
     * @param urlPattern the url pattern mapping
     */
    void addServletMapping(String servletName, String urlPattern) {
        if (servletMappings==null) {
            servletMappings = new HashMap();
        } 
        if (servletMappings.containsKey(servletName)) {
            ((Vector) servletMappings.get(servletName)).add(urlPattern);
        } else {
            Vector mappings = new Vector();
            mappings.add(urlPattern);
            servletMappings.put(servletName, mappings);
        }
    }
    
    /** 
     * receives notification of the end of an XML element by the Parser
     * 
     * @param element the xml tag identification
     * @return true if this node is done processing the XML sub tree
     */
    public boolean endElement(XMLElement element) {
        if (WebTagNames.DISTRIBUTABLE.equals(element.getQName())) {       
            ((SipApplication)getDescriptor()).setDistributable(true);
            return false;
        } else {
            boolean allDone = super.endElement(element);
            return allDone;
        }
    }

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
   /* public Node writeDescriptor(Node parent, Descriptor descriptor) {
        if (! (descriptor instanceof WebBundleDescriptor)) {
            throw new IllegalArgumentException(getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        WebBundleDescriptor webBundleDesc = (WebBundleDescriptor) descriptor;
        Node jarNode = super.writeDescriptor(parent, webBundleDesc);             
        if (webBundleDesc.isDistributable()) {
            appendChild(jarNode, WebTagNames.DISTRIBUTABLE);        
        }
        
        // context-param*
        addInitParam(jarNode, WebTagNames.CONTEXT_PARAM, webBundleDesc.getContextParametersSet());
        
        // listener*
        Vector appListeners = webBundleDesc.getAppListenerDescriptors();
        if (appListeners!=null && !appListeners.isEmpty()) {
            for (Enumeration e = appListeners.elements();e.hasMoreElements();) {
                AppListenerDescriptorImpl listener = (AppListenerDescriptorImpl) e.nextElement();
                Node listenerNode = appendChild(jarNode, WebTagNames.LISTENER);
                appendTextChild(listenerNode, WebTagNames.LISTENER_CLASS, listener.getListener());
            }
        }
        
        // servlet*
        Set servlets = webBundleDesc.getWebComponentDescriptorsSet();
        if (servlets!=null && !servlets.isEmpty()) {
            ServletNode servletNode = new ServletNode();
            for (Iterator  e= servlets.iterator();e.hasNext();) {
                WebComponentDescriptor aServlet = (WebComponentDescriptor) e.next();
                servletNode.writeDescriptor(jarNode, aServlet);
            }
        }
        
        // servlet-mapping*        
        if (servlets!=null && !servlets.isEmpty()) {
            for (Iterator servletsIterator = servlets.iterator(); servletsIterator.hasNext();) {
                WebComponentDescriptor aServlet = (WebComponentDescriptor) servletsIterator.next();                
                for (Iterator patterns = aServlet.getUrlPatternsSet().iterator();patterns.hasNext();) {
                    String pattern = (String) patterns.next();
                    Node mappingNode= appendChild(jarNode, WebTagNames.SERVLET_MAPPING);
                    appendTextChild(mappingNode, WebTagNames.SERVLET_NAME, aServlet.getCanonicalName());
                    
                    // If URL Pattern does not start with "/" then
                    // prepend it (for 1.2 Web apps)                    
                    if (webBundleDesc.getSpecVersion().equals("2.2")) {
                        if (!pattern.startsWith("/") 
                            && !pattern.startsWith("*.")) {
                            pattern = "/" + pattern;
                        }                    
                    }
                    appendTextChild(mappingNode, WebTagNames.URL_PATTERN, pattern);
		}                
            }
        }
        
        // session-config
        if (webBundleDesc.getSessionTimeout() != webBundleDesc.SESSION_TIMEOUT_DEFAULT) {
            Node config = appendChild(jarNode, WebTagNames.SESSION_CONFIG);
            appendTextChild(config, WebTagNames.SESSION_TIMEOUT, 
                                            String.valueOf(webBundleDesc.getSessionTimeout()));
        }
        
        
        // welcome-file-list?
        Enumeration welcomeFiles = webBundleDesc.getWelcomeFiles();
        if (welcomeFiles.hasMoreElements()) {
            Node welcomeList = appendChild(jarNode, WebTagNames.WELCOME_FILE_LIST);
            while (welcomeFiles.hasMoreElements()) {
                appendTextChild(welcomeList, WebTagNames.WELCOME_FILE,
                                (String) welcomeFiles.nextElement());
            }
        }
        

        // security-constraint*
        Enumeration securityConstraints = webBundleDesc.getSecurityConstraints();
        if (securityConstraints.hasMoreElements()) {
            SecurityConstraintNode scNode = new SecurityConstraintNode();
            while (securityConstraints.hasMoreElements()) {
                SecurityConstraintImpl sc = (SecurityConstraintImpl) securityConstraints.nextElement();
                scNode.writeDescriptor(jarNode, WebTagNames.SECURITY_CONSTRAINT, sc);
            }
        }

        // login-config ?
        LoginConfigurationImpl lci = (LoginConfigurationImpl) webBundleDesc.getLoginConfiguration();
        if (lci!=null) {
            LoginConfigNode lcn = new LoginConfigNode();
            lcn.writeDescriptor(jarNode, WebTagNames.LOGIN_CONFIG, lci);
        }
        
        // security-role*
        Enumeration roles = webBundleDesc.getSecurityRoles();
        if (roles.hasMoreElements()) {
            SecurityRoleNode srNode = new SecurityRoleNode();
            while (roles.hasMoreElements()) {
                SecurityRoleDescriptor role = (SecurityRoleDescriptor) roles.nextElement();
                srNode.writeDescriptor(jarNode, WebTagNames.ROLE, role);            
            }
        }

        // env-entry*
        writeEnvEntryDescriptors(jarNode, webBundleDesc.getEnvironmentProperties().iterator());

        // ejb-ref * and ejb-local-ref*
        writeEjbReferenceDescriptors(jarNode, webBundleDesc.getEjbReferenceDescriptors().iterator());

        // service-ref*
        writeServiceReferenceDescriptors(jarNode, webBundleDesc.getServiceReferenceDescriptors().iterator());

        // resource-ref*
        writeResourceRefDescriptors(jarNode, webBundleDesc.getResourceReferenceDescriptors().iterator());
                
        // resource-env-ref*
        writeResourceEnvRefDescriptors(jarNode, webBundleDesc.getJmsDestinationReferenceDescriptors().iterator());        

        // message-destination-ref*
        writeMessageDestinationRefDescriptors(jarNode, webBundleDesc.getMessageDestinationReferenceDescriptors().iterator());
        
        // persistence-context-ref*
        writeEntityManagerReferenceDescriptors(jarNode, webBundleDesc.getEntityManagerReferenceDescriptors().iterator());
        
        // persistence-unit-ref*
        writeEntityManagerFactoryReferenceDescriptors(jarNode, webBundleDesc.getEntityManagerFactoryReferenceDescriptors().iterator());
        
        // post-construct
        writePostConstructDescriptors(jarNode, webBundleDesc.getPostConstructDescriptors().iterator());

        // pre-destroy
        writePreDestroyDescriptors(jarNode, webBundleDesc.getPreDestroyDescriptors().iterator());

        return jarNode;
    } */
   
    static void addInitParam(Node parentNode, String nodeName, Set initParams) {
        if (!initParams.isEmpty()) {
            InitParamNode initParamNode = new InitParamNode();
            for (Iterator e=initParams.iterator();e.hasNext();) {
                EnvironmentProperty ep = (EnvironmentProperty) e.next();
                initParamNode.writeDescriptor(parentNode, nodeName, ep);
            }
        }    
    }
    
    static void addInitParam(Node parentNode, String nodeName, Enumeration initParams) {
        InitParamNode initParamNode = new InitParamNode();
        while (initParams.hasMoreElements()) {
            EnvironmentProperty ep = (EnvironmentProperty) initParams.nextElement();
            initParamNode.writeDescriptor(parentNode, nodeName, ep);
        }
    }
    
    /**
     * @return the default spec version level this node complies to
     */
    public String getSpecVersion() {
        return SPEC_VERSION;
    }
    
}
