/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.httplayers;

import java.util.ArrayList;
import java.util.List;
import org.jvnet.glassfish.comms.startup.stack.StackModel;


public class HttpLayerHandler implements StackModel<HttpLayer> {
    private static HttpLayerHandler instance = new HttpLayerHandler();
    private List<HttpLayer> httpLayers = new ArrayList<HttpLayer>();

    private HttpLayerHandler() {
    }

    public static HttpLayerHandler getInstance() {
        return instance;
    }

    /**
     * Gets a copy of the collection of HTTP layers
     *
     * @return a copy the collection of HTTP layers
     */
    public List<HttpLayer> getLayers() {
        return new ArrayList<HttpLayer>(httpLayers);
    }

    public void clear() {
        httpLayers.clear();
    }
    
    /**
     * Adds a layer.
     *
     * @param layer
     */
    public void addLayer(HttpLayer layer) {
        httpLayers.add(layer);
    }

    /**
     * Adds a basic layer.
     *
     * @param layer
     */
    public void addBasicLayer(HttpLayer layer) {
        httpLayers.add(0, layer);
    }
}

