/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/ 

package org.jvnet.glassfish.comms.deployment.annotations.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.logging.Level;

import org.jvnet.glassfish.comms.util.LogUtil;

import org.jvnet.glassfish.comms.deployment.backend.SipApplication;
import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.HandlerProcessingResult;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;

/**
 * 
 * @author Per Pettersson a.k.a. PellePedro
 * @since 15-Nov-07
 *
 */
public class SipApplicationHandler extends AbstractSipAnnotationHandler {

	
	@Override
	protected HandlerProcessingResult processAnnotation(
			SipApplication sipApplication, AnnotationInfo ainfo,
			ResourceContainerContext[] rcContexts)
			throws AnnotationProcessorException 
	{
        try {
            AnnotatedElement annotatedElement = ainfo.getAnnotatedElement();
            
            /*
             * 289 PR states that one application can be registered per sar achive.
             * An application is define in sip.xml or annotation package-info.java.
             * 
             *  We assume that only one sip application annotation can exist and
             *  the first processed taken as the SipApplication. 
             * 
             *  If a sip application is defined in sip.xml, the  annotation is ignored. 
             */
            Annotation [] annotation = annotatedElement.getAnnotations();
            for (int i = 0; i < annotation.length; i++) 
            {
            	Class annotationClass = annotation[i].annotationType();
            	if ( annotationClass == getAnnotationType() )
            	{
            		javax.servlet.sip.annotation.SipApplication sipApplicationAnnotation = 
            			(javax.servlet.sip.annotation.SipApplication) ainfo.getAnnotation();
            		
                        // Check if Application is already defined, that is
                        // multiple SipApplication annotations was found

                        if (sipApplication.getPackageName() != null) {
                            return getDefaultProcessedResult();
                        }
                        
            		// Retrieve the annotated package. 
            		// Servlets that are in the same package are part of same application. 
            		// Alternatively servlets can specify application name.
            			
            		try {
            		    Package annotatedPackage = (Package) annotatedElement;
            		    String annotatedPackageName = annotatedPackage.getName();

            		    // Set package name. All servlets in this package
            		    // belongs to the same
            		    // Sip Application by default
            		    sipApplication.setPackageName(annotatedPackageName);
            		} catch (java.lang.ClassCastException cce) {
                            if (theirLog.isLoggable(Level.SEVERE)) {
                                theirLog.log(Level.SEVERE, LOGPREFIX + "ClassCastException " +
                                		"while processing SipApplication annotation");
                             }
            		  return getDefaultFailedResult();
            		}

            		sipApplication.setAppName(sipApplicationAnnotation.name() );
            		sipApplication.setDescription(sipApplicationAnnotation.description());
            		sipApplication.setDisplayName(sipApplicationAnnotation.displayName());
            		sipApplication.setLargeIcon(sipApplicationAnnotation.largeIcon() );
            		sipApplication.setSmallIcon(sipApplicationAnnotation.smallIcon() );
            		
            		if (theirLog.isLoggable(Level.INFO)) {
            			theirLog.log(Level.INFO, LOGPREFIX + "SipApplication annotated name is [" + sipApplicationAnnotation.name() + "]");
            		}

            		if (sipApplicationAnnotation.distributable())
            		{
                		if (theirLog.isLoggable(Level.INFO)) {
                			theirLog.log(Level.INFO, LOGPREFIX + "SipApplication annotated distributable" );
                		}
            			sipApplication.setDistributable(true);
            		}

            		// Main Servlet
            		if(!"".equals( sipApplicationAnnotation.mainServlet()) )
            		{
            			String mainServlet = sipApplicationAnnotation.mainServlet();
                		if (theirLog.isLoggable(Level.INFO)) {
                			theirLog.log(Level.INFO, LOGPREFIX + "SipApplication annotated mainServlet is [" + mainServlet +"]");
                		}
                		
            			sipApplication.setMainservletName(mainServlet);
            		}
            		
            		int sessionTimeout = sipApplicationAnnotation.sessionTimeout();
            		
            		if ( sipApplication.getSessionConfigTimeout() < 1 )
            		{
            			// Not Specified
                		sipApplication.setSessionConfigTimeout(sessionTimeout);
                		
                		if (theirLog.isLoggable(Level.INFO)) {
                			theirLog.log(Level.INFO, LOGPREFIX + "SipApplication annotated sessionTimeout is [" + sessionTimeout + "]. This value can be changed in sip.xml ");
                		}
                		
            		} else {
                		if (theirLog.isLoggable(Level.INFO)) {
                			theirLog.log(Level.INFO, LOGPREFIX + "SipApplication sessionTimeout [" + sipApplication.getSessionConfigTimeout() + "]. This value was specified in sip.xml");
                		}
            		}
        		
            		int proxyTimeout = sipApplicationAnnotation.proxyTimeout();
            		
            		if ( sipApplication.getProxyConfigSequentialSearchTimeout() == 0 )
            		{
            			// Not Specified
                		sipApplication.setProxyConfigSequentialSearchTimeout(proxyTimeout);
                		
                		if (theirLog.isLoggable(Level.INFO)) {
                			theirLog.log(Level.INFO, LOGPREFIX + "SipApplication annotated proxyTimeout is [" + sessionTimeout + "]. This value can be changed in sip.xml");
                		}
                		
            		} else {
                		if (theirLog.isLoggable(Level.INFO)) {
                			theirLog.log(Level.INFO, LOGPREFIX + "SipApplication proxyTimeout [" + sipApplication.getProxyConfigSequentialSearchTimeout() +
                					"]. This value was specified in sip.xml");
                		}
            		}
            		
            	}
            }
        } catch (Exception e) {
            if (theirLog.isLoggable(Level.INFO)) {
                theirLog.log(Level.INFO, LOGPREFIX + "Exception at annotation processing");
            }
            return getDefaultFailedResult();
        }
        
		return getDefaultProcessedResult();
	}

	public Class<? extends Annotation> getAnnotationType() 
	{
		return javax.servlet.sip.annotation.SipApplication.class;
	}

}
