/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/
package org.jvnet.glassfish.comms.deployment.annotations.scanners;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.logging.Level;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.impl.AnnotationUtils;
import com.sun.enterprise.deployment.annotation.impl.WarScanner;


/**
 *
 * @author lmcpepe a.k.a. PellePedro
 * @since 15-Nov-07
 *
 */
public class SarScanner extends WarScanner {
    public SarScanner() {
        setCustomScaner(new SipAnnotationScanner());
    }

    public void initScanRepository(File archiveFile,
        WebBundleDescriptor webBundleDesc) throws IOException {
        initScanRepository(archiveFile, webBundleDesc, null);
    }

    /**
     * This scanner will scan the archiveFile for annotation processing.
     * @param archiveFile
     * @param webBundleDesc
     * @param classLoader
     */
    public void initScanRepository(File archiveFile,
        WebBundleDescriptor webBundleDesc, ClassLoader classLoader)
        throws IOException {
        if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
            AnnotationUtils.getLogger().fine("archiveFile is " + archiveFile);
            AnnotationUtils.getLogger().fine("webBundle is " + webBundleDesc);
            AnnotationUtils.getLogger().fine("classLoader is " + classLoader);
        }

        this.archiveFile = archiveFile;

        if (!archiveFile.isDirectory()) {
            // on client side
            return;
        }

        ArrayList<URL> repositoryUrl = new ArrayList<URL>();

        File webinf = new File(archiveFile, "WEB-INF");
        File classes = new File(webinf, "classes");

        if (classes.exists()) {
            repositoryUrl.add(classes.toURL());
            addScanDirectory(classes);
        }

        File lib = new File(webinf, "lib");

        if (lib.exists()) {
            File[] jarFiles = lib.listFiles(new FileFilter() {
                        public boolean accept(File pathname) {
                            return (pathname.isFile() &&
                            pathname.getAbsolutePath().endsWith(".jar"));
                        }
                    });

            if ((jarFiles != null) && (jarFiles.length > 0)) {
                for (File jarFile : jarFiles) {
                    repositoryUrl.add(jarFile.toURL());
                    addScanJar(jarFile);
                }
            }
        }

        URL[] classPath = new URL[repositoryUrl.size()];

        for (int i = 0; i < classPath.length; i++) {
            classPath[i] = repositoryUrl.get(i);
        }

        this.classLoader = new URLClassLoader(classPath,
                SarScanner.class.getClassLoader());
    }
}
