/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.admin.callflow.reporter;

import com.ericsson.ssa.container.callflow.Reporter;
import com.ericsson.ssa.container.sim.SipServletFacade;
import com.ericsson.ssa.sip.Layer;
import javax.servlet.Servlet;
import org.jvnet.glassfish.comms.admin.callflow.*;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.admin.monitor.callflow.RequestInfo;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.jvnet.glassfish.comms.util.LogUtil;


public class CallflowReporter implements Reporter {
    
    final static  Agent agent = Switch.getSwitch().getCallFlowAgent();
    final static Logger log = LogUtil.SMI_LOGGER.getLogger();

    public void reportPre(Layer l, SipServletRequest r) {
        if (log.isLoggable(Level.FINE))
            log.log(Level.FINE, "Pre Layer "+l+", req "+r+", agent "+agent);

        if( agent.isEnabled()){
            agent.requestStart(SipRequestType.REMOTE_SIP);
            agent.addRequestInfo(RequestInfo.CALLER_IP_ADDRESS, r.getRemoteAddr());
            agent.addRequestInfo(RequestInfo.REMOTE_USER, r.getRemoteUser());                       
            agent.startTime(SipContainerOrApplicationType.SIP_APPLICATION);   
        }
    }

    public void reportPost(Layer l, SipServletRequest r) {
        if (log.isLoggable(Level.FINE))
            log.log(Level.FINE, "Post Layer "+l+", req "+r+", agent "+agent);

        if( agent.isEnabled()){
            agent.endTime();
            agent.requestEnd();
        }
    }

    public void reportPre(Layer l, SipServletResponse r) {
        //CallFlow is only on requests
    }

    public void reportPost(Layer l, SipServletResponse r) {
        //CallFlow is only on requests        
    }

    public void reportPre(SipServletFacade f, SipServletRequest r) {
        if (log.isLoggable(Level.FINE))
            log.log(Level.FINE, "Pre Servlet "+f+", req "+r+", agent "+agent);
        
        if( agent.isEnabled()){
            String callerPrincipal = r.getRemoteUser();
            if (callerPrincipal == null) {
                if (r.getUserPrincipal() != null) {
                    callerPrincipal = r.getUserPrincipal().getName();
                } else {
                    callerPrincipal = "anonymous";
                }
            }

            String appName = f.getDeploymentServlet().getApplicationName();
                
            agent.webMethodStart("service", 
                    ((appName!=null)  ? appName : f.getName()),
                    "SIP Module", 
                    f.getName(), 
                    ComponentType.SERVLET, 
                    callerPrincipal);
        }        
    }

    public void reportPost(SipServletFacade s, SipServletRequest r) {
        if (log.isLoggable(Level.FINE))
            log.log(Level.FINE, "Post Servlet "+s+", req "+r+", agent "+agent);

        if( agent.isEnabled()){
            agent.webMethodEnd(null);
        }        
    }

    public void reportPost(SipServletFacade s, SipServletRequest r, Exception e) {
        if (log.isLoggable(Level.FINE))
            log.log(Level.FINE, "Post Servlet "+s+", req "+r+", agent "+agent);

        if( agent.isEnabled()){
            agent.webMethodEnd(e);
        }        
    }
}
