/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.admin.config;

import com.ericsson.ssa.config.Config;

import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.config.ConfigBean;

import org.netbeans.modules.schema2beans.BaseBean;


public interface ConfigBean2InternalMapper {
    //EventListener registration
    boolean requiresEventListerenerRegistration();

    String getEventType();

    AdminEventListener getEventListenerImpl(ConfigAdapter configMapper);

    Class getEventListenerClass();

    //Mapping
    /**
     * Maps the ConfigBean to the internal structure.
     * @param bean the bean to be mapped.
     * @param ctxHolder the the path to the root element pass within a holder
     * array to allow the implementer to suggest a new ctx to be used when
     * traversing the suggested childeren.
     * @param config the internal Config.
     * @return the the childeren of the bean still to be traverse after mapping.
     */
    BaseBean[] map2Internal(ConfigBean bean, String[] ctxHolder, Config config);

    /**
     * Remaps the ConfigBean to the internal structure.
     * @param bean the bean to be mapped.
     * @param ctxHolder the the path to the root element pass within a holder
     * array to allow the implementer to suggest a new ctx to be used when
     * traversing the suggested childeren.
     * @param config the internal Config.
     * @return the the childeren of the bean still to be traverse after remapping.
     */
    BaseBean[] remap2Internal(ConfigBean bean, String[] ctxHolder, Config config);

    /**
     * Unmaps the ConfigBean to the internal structure.
     * @param bean the bean to be mapped.
     * @param ctxHolder the the path to the root element pass within a holder
     * array to allow the implementer to suggest a new ctx to be used when
     * traversing the suggested childeren.
     * @param config the internal Config.
     * @return the the childeren of the bean still to be traverse after unmapping.
     */
    BaseBean[] unmap2Internal(ConfigBean bean, String[] ctxHolder, Config config);
}
