/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/
package org.jvnet.glassfish.comms.admin.monitor;

import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.transaction.TransactionManager;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;



public class TransactionManagerStatsImpl implements TransactionManagerStats, SipStats {
    private MutableCountStatistic sipClientTransactions;
    private MutableCountStatistic sipServerTransactions;
    private MutableCountStatistic totalSipTransactionCount;
    private MutableCountStatistic totalSipTransactionTime;
    private TransactionManager transactionManager = null;
    private GenericStatsImpl baseStatsImpl;

    public TransactionManagerStatsImpl() {
        initializeStatistics();
        baseStatsImpl = new GenericStatsImpl(TransactionManagerStats.class, this);
    }

    public void setStatsProvider(Layer provider) {
        this.transactionManager = (TransactionManager)provider;
    }

    private void initializeStatistics() {
        CountStatistic c;
        c = new CountStatisticImpl("sipClientTransactions");
        sipClientTransactions = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("sipServerTransactions");
        sipServerTransactions = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("totalSipTransactionCount");
        totalSipTransactionCount = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("totalSipTransactionTime");
        totalSipTransactionTime = new MutableCountStatisticImpl(c);
    }

    public CountStatistic getSipClientTransactions() {
        sipClientTransactions.setCount((transactionManager == null) ? 0
                                                                    : transactionManager.getEasSipClientTransactions());

        return (CountStatistic) sipClientTransactions.unmodifiableView();
    }

    public CountStatistic getSipServerTransactions() {
        sipServerTransactions.setCount((transactionManager == null) ? 0
                                                                    : transactionManager.getEasSipServerTransactions());

        return (CountStatistic) sipServerTransactions.unmodifiableView();
    }

    public CountStatistic getTotalSipTransactionCount() {
        totalSipTransactionCount.setCount((transactionManager == null) ? 0
                                                                       : transactionManager.getEasTotalSipTransactionCount());

        return (CountStatistic) totalSipTransactionCount.unmodifiableView();
    }

    public CountStatistic getTotalSipTransactionTime() {
        totalSipTransactionTime.setCount((transactionManager == null) ? 0
                                                                      : transactionManager.getEasTotalSipTransactionTime());

        return (CountStatistic) totalSipTransactionTime.unmodifiableView();
    }

    public Statistic getStatistic(String name) {
        return baseStatsImpl.getStatistic(name);
    }

    public String[] getStatisticNames() {
        return baseStatsImpl.getStatisticNames();
    }

    public Statistic[] getStatistics() {
        return baseStatsImpl.getStatistics();
    }

    public Class getInterfaceClass() {
        return TransactionManagerStats.class;
    }

}
