/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.startup;

import com.sun.enterprise.web.VirtualServer;

import org.apache.catalina.ContainerEvent;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;

import org.jvnet.glassfish.comms.util.LogUtil;

import java.util.logging.Level;
import java.util.logging.Logger;


public class SipServiceListener implements LifecycleListener {
    private Logger log = LogUtil.SIP_LOGGER.getLogger();

    public SipServiceListener() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "sip.integration.sip_service_listener_construction", getClass().getName());
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        //Please delegate the work to SipContainer.
        try {
            if (Lifecycle.BEFORE_START_EVENT.equals(event.getType())) {
                SipContainer.instance().registerAtVirtualServer((VirtualServer)event.getSource());
                SipContainer.instance().startSipStack();

                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Received Before Start Event");
                }
            } else if (Lifecycle.AFTER_START_EVENT.equals(event.getType())) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Received After Start Event");
                }
            } else if (Lifecycle.STOP_EVENT.equals(event.getType())) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Received Stop Event");
                }
                SipContainer.instance().stopSipStack();
            }
        } catch (Throwable e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "sip.integration.lifecycle_failure_continue", event.getType().toString());
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void containerEvent(ContainerEvent event) {
        //Can be good to know perhaps!?
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Container event : " + event);
        }
    }
}
