/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.startup.lifecycle;

import com.sun.appserv.server.LifecycleEvent;
import com.sun.appserv.server.LifecycleEventContext;
import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycleException;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.jvnet.glassfish.comms.startup.stack.StackConfigException;
import org.jvnet.glassfish.comms.startup.SipContainer;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 * This class represents the lifecycle listener for the SipContainer lifecycle
 * module. This module is defined as a lifecycle-module in the domain.xml and
 * would be used to do the required initialization for Sailfin
 * @author Prasad Subramanian
 */
public class SipContainerLifecycle implements LifecycleListener {
    private static Logger logger = LogUtil.SIP_LOGGER.getLogger();
    private static final String[] EVENT_TYPES;
    static {
         EVENT_TYPES = new String[5];
         EVENT_TYPES[LifecycleEvent.INIT_EVENT] = "INIT_EVENT";
         EVENT_TYPES[LifecycleEvent.STARTUP_EVENT] = "STARTUP_EVENT";
         EVENT_TYPES[LifecycleEvent.READY_EVENT] = "READY_EVENT";
         EVENT_TYPES[LifecycleEvent.SHUTDOWN_EVENT] = "SHUTDOWN_EVENT";
         EVENT_TYPES[LifecycleEvent.TERMINATION_EVENT] = "TERMINATION_EVENT";         
    }

    /**
     *  Handles the event and delegates to methods for each event type
     *  @param  event the LifecycleEvent
     *  @throws ServerLifecycleException
     */
    public void handleEvent(LifecycleEvent event)
        throws ServerLifecycleException {        
        LifecycleEventContext ctx = event.getLifecycleEventContext();
        ctx.log("got event" + event.getEventType() + " event data: " +
            event.getData());
        switch (event.getEventType()) {
        case LifecycleEvent.INIT_EVENT:
            onInitialization(ctx);
            break;
        case LifecycleEvent.STARTUP_EVENT:
            onStartup(ctx);
            break;
        case LifecycleEvent.READY_EVENT:
            onReady(ctx);
            break;
        case LifecycleEvent.SHUTDOWN_EVENT:
            onShutdown();
            break;
        case LifecycleEvent.TERMINATION_EVENT:
            onTermination();
            break;
        }
    }
    /**
     *  Method to handle the INIT_EVENT
     */
    public void onInitialization(LifecycleEventContext sc)
        throws ServerLifecycleException {
        //Please delegate the work to SipContainer.        
        
        if (logger.isLoggable(Level.FINE))
            logger.fine("SipLifecycleListener: In the OnInitialization method");
        // do the registration of Deployer
        SipContainer.instance().registerDeployer();
        
        //Startup Config
        SipContainer.instance().initConfig();
        
        SipContainer.instance().initSystemInfo();
                
        // Create HTTP Stack
        try {
            SipContainer.instance().initHttpLayerHandler();
        } catch (StackConfigException ex) {
            throw new ServerLifecycleException("Initializating stack for HTTP failed.", ex);
        }
            
        SipContainer.instance().initClbAdmin();
        SipContainer.instance().registerRealmAdapter();
        
        SipContainer.instance().resolveSipBindings();
        
        // Create SIP Stack
        try {
            SipContainer.instance().initLayerHandler();
        } catch (StackConfigException ex) {
            throw new ServerLifecycleException("Initializating stack for SIP failed.", ex);
        }
    }

    /**
     *  Method to handle the START_EVENT
     */
    public void onStartup(LifecycleEventContext sc)
        throws ServerLifecycleException {        
        //Please delegate the work to SipContainer.        
        
        SipContainer.instance().registerFeatureName();
        SipContainer.instance().initMonitoring();
        SipContainer.instance().bindSipResources(); 
    }

    /**
     *  Method to handle the READY_EVENT
     */
    public void onReady(LifecycleEventContext sc)
        throws ServerLifecycleException {
        //Please delegate the work to SipContainer.        
        
        SipContainer.instance().reportReady();
    }

    /**
     *  Method to handle the SHUTDOWN_EVENT
     */
    public void onShutdown() throws ServerLifecycleException {
        //Please delegate the work to SipContainer.        
    }

    /**
     *  Method to handle the TERMINATION_EVENT
     */
    public void onTermination() throws ServerLifecycleException {
        //Please delegate the work to SipContainer.                
    }
}
