/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.startup.stack;

import java.lang.reflect.Method;
import java.util.Map;
import org.jvnet.glassfish.comms.httplayers.HttpLayer;

/**
 * A SipContainer internal Config based StackConfigProviders for Http
 * Layers. As a side byproduct it initialize the HttpProxy of the Converged
 * LoadBallancer.
 * @author ELNELBO
 */
public class ConfigStackConfigProviderForHttp extends 
        ConfigStackConfigProviderBase<StackModel<HttpLayer>, HttpLayer> implements
        StackConfigProvider<StackModel<HttpLayer>> {
    private static final String LAYER_INIT_METHOD = "getHttpLayerInstance";         
    
    private static final String HTTP_PROXY_CLASS_NAME = "org.jvnet.glassfish.comms.clb.proxy.HttpProxy";
    private static final String HTTP_PROXY_ADD_LAYER_METHOD = "addLayer";
    private static final String HTTP_PROXY_GET_INSTANCE_METHOD = "getInstance";
    
    private Object httpProxyObject;
    private Method addLayerMethod;

    public ConfigStackConfigProviderForHttp(ClassLoader aClassLoader) {
        super(aClassLoader);
    }
    
    @Override
    protected boolean isAcceptedStackLayer(String id, String layerClassName, 
            String factoryClassName, Map<String, String> properties) {
        boolean expected = properties!=null &&
                Boolean.parseBoolean(properties.get(StackConfig.HTTP_LAYER_INDICATOR_KEY));
        
        return expected;
    }
    
    @Override
    protected void addLayerToModel(StackModel<HttpLayer> sm, HttpLayer layer)
            throws StackConfigException {
            //[Eltjo] In my opinion the HTTP_PROXY is actually the real StackModel for Http
            //It is now initalized as byproduct from the stack initialized.
        if (addLayerMethod==null) {
            try {
                Class httpProxyClass = Class.forName(HTTP_PROXY_CLASS_NAME);
                Method getInstanceMethod = httpProxyClass.getMethod(HTTP_PROXY_GET_INSTANCE_METHOD, (Class[]) null);
                httpProxyObject = getInstanceMethod.invoke((Object) null, (Object[]) null);
                addLayerMethod = httpProxyClass.getMethod(HTTP_PROXY_ADD_LAYER_METHOD, HttpLayer.class);
            } catch (Exception ex) {
               throw new StackConfigException("Failed to initialize the HttpProxy", ex);
            }
        }
        
        try {
            addLayerMethod.invoke(httpProxyObject, layer);
        } catch (Exception ex) {
           throw new StackConfigException("Failed to add Layer to the HttpProxy", ex);
        }
        
        //This is different behaviour than the dispathcer.xml HttpLayerRule!
        //Comment out to go back.
      //  super.addLayerToModel(sm, layer);
    }
    
    protected String getLayerInitMethod() {
        return LAYER_INIT_METHOD;
    }
    
    protected String getFactoryInitMethod() {
        return null;
    }
    
    protected boolean isLayerFactorizationAllowed() {
        return false;
    }
    
    protected boolean isStaticPropertyInjectionAllowed() {
        return false;
        
    }
    protected boolean isConfigPropertyInjectionAllowed() {
        //Although we could allow the HttpLayers also to introspect for
        //Configuration Annotations we don't, because the possibility that
        //when the HttpLayer is also the Layer, sharing the same instance
        //there is the possibility that static properties overwrite.
        //Therefore HttpLayer instance that are not also shared instance Layers.
        //Have to activateConfiguration manually for there annotations.
        return false;        
    }    
}
