/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.replication.dialogmgmt;

import org.jvnet.glassfish.comms.replication.sessmgmt.*;
import java.io.*;

/**
 * Class containing the extra parameters for a dialogFragment.
 *
 * Extra parameters are parameters that are likely to change very
 * frequently. Rather than having to serialize the entire dialogFragment state
 * when any of the extra parameters change, the extra parameters are
 * serialized and replicated separately from the dialogFragment's state.
 *
 * When a dialogFragment is deserialized on a replica instance, its state is
 * overlayed with the latest version of the corresponding extra parameters.
 *
 * @author jluehe
 * @author lwhite
 */
public class DialogFragmentExtraParams implements Serializable {
    private static final long serialVersionUID = 1L;

    /** The serialized format versioning. 1 = first version. */
    private static short serializedFormVersion  = 1;

    // used by migration during upgrade
    private transient String currentOwnerInstanceName;
    
    // This is an absolute time
    private transient long expirationTime;

    // FIXME  Is this really not needed
    //private transient int cseq;
    
    private transient long internalLastAccessedTime;

    // The associated dialogFragment
    private transient final HADialogFragment dialogFragment;

    // The id of the associated dialogFragment
    private transient String id;

    private transient int hc;
    
    private enum Mode {NON_QUERY_MODE, FIND_BY_OWNER, FIND_ALL};

    private Mode mode = Mode.NON_QUERY_MODE;    

    // For deserialization.
    public DialogFragmentExtraParams() {
        dialogFragment = null;
    }

    /**
     * Constructor
     *
     * @param dialogFragment The associated dialogFragment
     */
    public DialogFragmentExtraParams(HADialogFragment df) {
        this.dialogFragment = df;
        //df can be null for a criteria object
        if(df != null) {
            this.id = df.getDialogId();
            this.hc = id.hashCode();
        }
    }
    
    static DialogFragmentExtraParams createSearchCriteria(String currentOwnerInstanceName) {
        DialogFragmentExtraParams queryTemplate = new DialogFragmentExtraParams(null);
        queryTemplate.mode = Mode.FIND_BY_OWNER;
        queryTemplate.currentOwnerInstanceName = currentOwnerInstanceName;
        return queryTemplate;
    }    
    
    static DialogFragmentExtraParams createSearchCriteriaAll() {
        DialogFragmentExtraParams queryTemplate = new DialogFragmentExtraParams(null);
        queryTemplate.mode = Mode.FIND_ALL;
        return queryTemplate;
    }    

    public String getId() {
        return id;
    }

    public String getCurrentOwnerInstanceName() {
        if (dialogFragment != null) {
            return dialogFragment.getCurrentOwnerInstanceName();
        } else {
            return currentOwnerInstanceName;
        }
    }

    public long getExpirationTime() {
        if (dialogFragment != null) {
            return dialogFragment.getExpirationTime();
        } else {
            return expirationTime;
        }
    }

    public long getInternalLastAccessedTime() {
        if (dialogFragment != null) {
            return dialogFragment.getInternalLastAccessedTime();
        } else {
            return internalLastAccessedTime;
        }               
    }     

    /*  FIXME Is there no cseq for DialogFragment.
    public int getCseq() {
        if (dialogFragment != null) {
            //return dialogFragment.getCseq();
            return -1; // FIXME
        } else {
            return cseq;
        }
    }
    */    
    
    public boolean equals(Object obj) {
         switch (this.mode) {
         case FIND_ALL:
            //Search mode
            if (obj instanceof DialogFragmentExtraParams) {
                //return all instances of DialogFragmentExtraParams
                return true;
            } else {
                return false;
            }
         case FIND_BY_OWNER:
            //Search mode
            if (obj instanceof DialogFragmentExtraParams) {
                DialogFragmentExtraParams that = (DialogFragmentExtraParams) obj;
                return getCurrentOwnerInstanceName().equals(that.currentOwnerInstanceName);
            } else {
                return false;
            }            
         default:
            if (obj == this) {
                return true;
            }
    
            if (! (obj instanceof DialogFragmentExtraParams)) {
                return false;
            }
    
            DialogFragmentExtraParams that = 
                (DialogFragmentExtraParams) obj;
            return this.id.equals(that.id);
        }
    }     

    public int hashCode() {
        if (mode != Mode.NON_QUERY_MODE) {
            throw new IllegalStateException("illegal use of criteria extra param");
        }
        return hc;
    }

    /**
     * @serialData See serialized form version 1 in #readObject(ObjectInputStream in)
     *  
     * @param oos the stream to write the object members
     * @throws IOException 
     * @throws ClassNotFoundException
     */    
    private void writeObject(ObjectOutputStream oos)
            throws IOException {
        oos.writeShort(serializedFormVersion);
        
        oos.writeObject(id);
        oos.writeObject(getCurrentOwnerInstanceName());
        oos.writeLong(getExpirationTime());
        //oos.writeObject(getDialogFragmentId());
        //oos.writeInt(getCseq());
        oos.writeLong(getInternalLastAccessedTime());
    }

    /**
     * @serialData first field is an short and represents the serializedFormVersion.<br>
     * <h3>Data layout for serializedFormVersion = 1 follows</h3>
     * 
     * <li>field is a <b>String</b> and represents the dialogFragmentId field</li>
     * <li>field is a <b>String</b> and represents the name of the owner instance when this instance was serialized</li>
     * <li>field is a <b>Long</b> and represents the expirationTime field as absolute time</li>
     * <li>field is a <b>Long</b> and represents the internalLastAccessedTime field as absolute time</li>
     *  
     * @param in the stream to read the object members
     * @throws IOException is thrown when unsupported version is detected
     * @throws ClassNotFoundException
     */    
    private void readObject(ObjectInputStream in)
            throws IOException, ClassNotFoundException {
        short readSerializedFormVersion = in.readShort();
        switch(readSerializedFormVersion) {
        case 1:
            id = (String) in.readObject();
            hc = id.hashCode();
            currentOwnerInstanceName = (String) in.readObject();
            expirationTime = in.readLong();
            //cseq = in.readInt();
            internalLastAccessedTime = in.readLong();
            break;
        default:
            throw new IOException("Unable to deserialize into "
                    + this.getClass().getName()
                    + " due to unknown serializedFormVersion of "
                    + readSerializedFormVersion);
        }
    }
}
