/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.replication.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.FederatedQueryProcessor;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationSender;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationResponseRepository;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationUtil;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.logging.Level;
import java.util.concurrent.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jvnet.glassfish.comms.util.LogUtil;

/**
 *
 * @author Larry White
 */
public class FederatedExpatListRequestProcessor implements Callable, FederatedQueryProcessor {
    
    private static final Logger _logger = Logger.getLogger(LogUtil.SIP_LOG_DOMAIN);
    
    public final static String RETURN_BROADCAST_MSG_COMMAND 
        = ReplicationState.RETURN_BROADCAST_MSG_COMMAND;  //"broadcastResponse";    
    
    /**
     * Creates a new instance of FederatedExpatListRequestProcessor
     */
    public FederatedExpatListRequestProcessor(ReplicationState aSendQueryState, int numberOfRequests, long waitTime) {
        sendQueryState = aSendQueryState;
        counter = numberOfRequests;
        waitTimeMillis = waitTime;
    }
    
    public ReplicationState doFederatedQuery() {
        ReplicationState result = null;
        result = this.call();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("FederatedExpatListRequestProcessor>>doFederatedQuery:result = " + result);
        }        
        if(result != null) {
            ReplicationResponseRepository.putEntry(result);
        }
        cleanup();
        return result;
    } 
    
    public ReplicationState call() {
        JxtaReplicationSender sender = null;
        synchronized(this) {
            //first send messages
            sender = JxtaReplicationSender.createInstance();
            sender.sendBroadcastQuery(sendQueryState);
            //now block and wait for time or all responses back
            try {
                wait(waitTimeMillis);
            } catch(InterruptedException ex) {
                //nothing
            }
        }
        return prepareFinalResult();
        
    }   
    
    private ReplicationState prepareFinalResult() {
        //combine the List of results - serialize them
        //as a list and set that as the state of the final
        //result
        HashMap finalMap = new HashMap();
        //for each ReplicationState in the federated resultList
        for(int i=0; i<resultList.size(); i++) {
            ReplicationState nextState 
                = (ReplicationState)resultList.get(i);
            //get the expat list from the state
            ArrayList nextExpatList = null;
            try {
                nextExpatList 
                    = (ArrayList)ReplicationState.getObjectValue(nextState.getState());
            } catch (Exception ex) {
                //deliberate no-op
                ;
            }
            if(nextExpatList != null) {
                //iterate over the expatList; add selectively to final map
                for(int j=0; j<nextExpatList.size(); j++) {
                    ExpatListElement nextExpat 
                        = (ExpatListElement)nextExpatList.get(j);
                    if(nextExpat != null) {
                        //get any existing expat in the map
                        ExpatListElement existingExpat 
                            = (ExpatListElement)finalMap.get(nextExpat.getId());
                        if(existingExpat == null || existingExpat.getVersion() < nextExpat.getVersion()) {
                            finalMap.put(nextExpat.getId(), nextExpat);
                        }
                    }
                }
            }
        }
        //serialize the final map and use it as the state in the query result
        byte[] expatMapState = null;
        try {
            expatMapState = ReplicationUtil.getByteArray((HashMap)finalMap);
        } catch (IOException ex) {
            ;
        }
        if(result != null) {
            return ReplicationState.createUpdatedStateFrom(result, result.getCommand(), expatMapState);
        } else {
            return ReplicationState.createUpdatedStateFrom(sendQueryState, RETURN_BROADCAST_MSG_COMMAND, expatMapState);
        }
    }
    
    public synchronized void processQueryResponse(ReplicationState incomingState) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("FederatedExpatListRequestProcessor:processQueryResponse:incomingVersion=" + incomingState.getVersion() 
                + " source_instance= " + incomingState.getInstanceName() 
                + " counter=" + counter);
        }         
        //two main alternatives nack or not
        if(isNack(incomingState)) { //nack case
            counter--;
        } else { //non-nack case
            if(result == null) {
                result = incomingState;
            }            
            resultList.add(incomingState);
            counter--;
        }
        if(counter == 0) {
            this.notify();
        }
    } 
    
    boolean isNack(ReplicationState incomingState) {
        return incomingState.isNack();
    }    
    
    private void cleanup() {
        result = null;
        sendQueryState = null;
        counter = 0;
        waitTimeMillis = 0L;
        resultList = new ArrayList();
    }    
    
    private ReplicationState sendQueryState = null;
    private ReplicationState result = null;
    //list of ReplicationState
    private List resultList = new ArrayList();
    private int counter = 0;
    private long waitTimeMillis = 0L;    

}
