/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.security;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.config.serverbeans.SipService;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.util.Iterator;
import javax.servlet.sip.SipServlet;
import org.jvnet.glassfish.comms.deployment.backend.SipBundleDescriptor;


/**
 *
 * @author K.Venugopal@sun.com
 */
public class RealmAdapter extends com.sun.web.security.RealmAdapter {

    public RealmAdapter(WebBundleDescriptor descriptor,
            boolean isSystemApp,
            String realmName) {
        super(descriptor, isSystemApp, realmName);
        if (descriptor instanceof SipBundleDescriptor) {
            SipBundleDescriptor sbd = (SipBundleDescriptor) descriptor;
            Iterator<String> itr = sbd.getServletsWithRunAs();
            while (itr.hasNext()) {
                String servletName = itr.next();
                String principal = sbd.getRunAsPrincipal(servletName);
                addRunAsPrincipal(servletName, principal);
            }

        }
    }

    protected String getServletName(ComponentInvocation inv) {
        Object invInstance = inv.getInstance();
        
        if (invInstance instanceof SipServlet) {
            SipServlet servlet = (SipServlet) invInstance;
            javax.servlet.ServletConfig config = servlet.getServletConfig();
            if(config != null){
                return config.getServletName();
            }
            return null;
        } else {
            return super.getServletName(inv);
        }
    }
}
