/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.security.auth.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import java.util.StringTokenizer;
import javax.servlet.sip.SipServletMessage;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class AuthHeaderProcessor {

    public List<String> headers = null;

        public List<String> getHeaderValues(SipServletMessage message,
            String headerName) {
        headers = new ArrayList<String>();
        @SuppressWarnings(value = "unchecked")
        ListIterator<String> params = message.getHeaders(headerName);

        if (params == null) {
            return null;
        }
        while (params.hasNext()) {
            String currentToken = params.next();
            process(currentToken);
        }

        return headers;
    }

    private void process(String value) {
        int index = value.indexOf("Digest");
        String token;
        if (index >= 0) {
            token = value.substring(index + "Digest".length());
            int endIndex = token.indexOf("Digest");
            if (endIndex > 0) {
                headers.add(token.substring(0, endIndex));
                process(token.substring(endIndex, token.length()));
            } else {
                headers.add(token);
            }
        }
    }

    public String[] getHeaderValues(SipServletMessage message,
            String headerName, String headerValueName) {
        @SuppressWarnings(value = "unchecked")
        List<String> params = getHeaderValues(message, headerName);

        if (params == null) {
            return null;
        }

        ArrayList<String> realms = new ArrayList<String>();

        if (params == null) {
            return null;
        }
        String realm;

        Iterator<String> itr = params.iterator();
        while (itr.hasNext()) {
            String token = itr.next();

            StringTokenizer commaTokenizer = new StringTokenizer(token, ",");

            while (commaTokenizer.hasMoreTokens()) {
                java.lang.String currentToken = commaTokenizer.nextToken();
                int equalSign = currentToken.indexOf('=');
                if (equalSign < 0) {
                    return null;
                }
                java.lang.String currentTokenName = currentToken.substring(0, equalSign).trim();
                java.lang.String currentTokenValue = currentToken.substring(equalSign + 1).trim();
                if ("realm".equals(currentTokenName)) {
                    realm = AuthHeaderProcessor.removeQuotes(currentTokenValue, true);
                    realms.add(realm);
                }
            }
        }

        return realms.toArray(new String[0]);
    }

    public static String removeQuotes(String quotedString,
            boolean quotesRequired) {
        //support both quoted and non-quoted
        if ((quotedString.length() > 0) && (quotedString.charAt(0) != '"') &&
                !quotesRequired) {
            return quotedString;
        } else if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        } else {
            return new String();
        }
    }
}
