/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.security.auth.impl;

import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.sip.AuthInfo;


/**
 *
 * @author K.Venugopal@sun.com
 */
public class AuthInfoImpl implements AuthInfo {
    private HashMap<String, Info> authInfo = new HashMap<String, Info>();

    public void addAuthInfo(int statusCode, String realm, String username,
        String password) {
        Info ai = new Info();
        ai.password = password;
        ai.statusCode = statusCode;
        ai.realm = realm;
        ai.username = username;
        authInfo.put(realm, ai);
    }

    public Iterator<String> getRealmNames() {
        return authInfo.keySet().iterator();
    }

    public int getStatusCode(String realmname) {
        if (authInfo.containsKey(realmname)) {
            return authInfo.get(realmname).statusCode;
        }

        return -1;
    }

    public String getPassword(String realmname) {
        if (authInfo.containsKey(realmname)) {
            return authInfo.get(realmname).password;
        }

        return null;
    }

    public String getUserName(String realmname) {
        if (authInfo.containsKey(realmname)) {
            return authInfo.get(realmname).username;
        }

        return null;
    }

    class Info {
        String realm = "";
        String username = "";
        String password = "";
        int statusCode;
    }
}
