/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.security.authorize;

import java.security.Permission;


/**
 *
 * @author K.Venugopal@sun.com
 */
public class SipRoleRefPermission extends Permission {
    String role;

    public SipRoleRefPermission(String name, String role) {
        super(name);
        this.role = role;
    }

    public boolean implies(Permission perm) {
        if (!(perm instanceof SipRoleRefPermission)) {
            return false;
        }

        SipRoleRefPermission srp = (SipRoleRefPermission) perm;

        if ((this.getName() != null) && this.getName().equals(srp.getName())) {
            if ((this.role != null) && this.role.equals(srp.role)) {
                return true;
            }
        }

        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SipRoleRefPermission)) {
            return this.implies((SipRoleRefPermission) obj);
        }

        return false;
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer();
        sb.append(role);
        sb.append(this.getName());

        return sb.toString().hashCode();
    }

    public String getActions() {
        return this.role;
    }
}
