/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.security.util;

import com.sun.enterprise.deployment.runtime.web.Servlet;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Group;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.deployment.runtime.common.PrincipalNameDescriptor;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.security.AppservAccessController;
import com.sun.enterprise.security.SecurityContext;
import com.sun.web.security.WebPrincipal;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyConfigurationFactory;
import org.jvnet.glassfish.comms.deployment.backend.SipBundleDescriptor;

/**
 *
 * @author K.Venugopal@sun.com
 */
public final class PolicyBuilder {

    String trustClassName = null;

    public PolicyConfiguration getInstance(String contextId)
            throws PolicyContextException {
        PolicyConfigurationFactory pfi = null;
        try {
            pfi = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        } catch (java.lang.ClassNotFoundException cne) {
            throw new PolicyContextException(cne);
        }
        return pfi.getPolicyConfiguration(contextId, false);
    }

    public void createRoleMapper(BundleDescriptor descriptor, String name) {

        if (descriptor instanceof SipBundleDescriptor) {

            SipBundleDescriptor sbd = (SipBundleDescriptor) descriptor;
            SunWebApp sunSipDesc = sbd.getSipApplication().getSunSipDescriptor();
            SecurityRoleMapping[] srmList = sunSipDesc.getSecurityRoleMapping();

            //SecurityRoleMapping[] srmList = ((WebBundleDescriptor) descriptor).getSunDescriptor().getSecurityRoleMapping();
            SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryMgr.getFactory();

            //super.getDescriptor().getApplication().getRoleMapper().getName();
            if (srmList == null) {
                return;
            }

            for (int si = 0; si < srmList.length; si++) {
                SecurityRoleMapping srm = srmList[si];
                Role role = new Role(srm.getRoleName());
                SecurityRoleMapper rm = factory.getRoleMapper(name);

                if (rm != null) {
                    List<PrincipalNameDescriptor> principals = srm.getPrincipalNames();

                    for (int i = 0; i < principals.size(); i++) {
                        rm.assignRole(principals.get(i).getPrincipal(), role,
                                descriptor);
                    }

                    List<String> groups = srm.getGroupNames();

                    for (int i = 0; i < groups.size(); i++) {
                        rm.assignRole(new Group(groups.get(i)), role, descriptor);
                    }
                }
            }
        }

    }

    public void setPolicyContext(final String ctxID) throws Throwable {

        String old = PolicyContext.getContextID();

        try {
            AppservAccessController.doPrivileged(new PrivilegedExceptionAction() {

                public java.lang.Object run() throws Exception {
                    PolicyContext.setContextID(ctxID);
                    return null;
                }
                });
        } catch (java.security.PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            //log exception.
            throw cause;
        }
    }

    public Subject getCurrentSubject() {
        SecurityContext secCtx = SecurityContext.getCurrent();
        Subject subject = secCtx.getSubject();
        return subject;
    }

    public void setSecurityContext(Object obj) {
        if (obj instanceof SecurityContext) {
            SecurityContext.setCurrent((SecurityContext) obj);
        }
    }

    public Object getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    public Subject getSubject(Principal principal) {
        SecurityContext secContext = null;
        if (principal != null) {
            if (principal instanceof WebPrincipal) {
                WebPrincipal wp = (WebPrincipal) principal;
                secContext = wp.getSecurityContext();
            } else {
                secContext = new SecurityContext(principal.getName(), null);
            }
        }
        if (secContext == null) {
            secContext = SecurityContext.getDefaultSecurityContext();
        }
        return secContext.getSubject();
    }
    
    
    public Map<String, String> readRunAs(BundleDescriptor descriptor, Map<String, String> srMap) {
        Map runAs = new HashMap<String,String>();
        if (descriptor instanceof SipBundleDescriptor) {
            SipBundleDescriptor sbd = (SipBundleDescriptor) descriptor;
            SunWebApp sunSipDesc = sbd.getSipApplication().getSunSipDescriptor();
            Servlet[] servlets = sunSipDesc.getServlet();
            if (servlets != null) {
                for (int i = 0; i < servlets.length; i++) {
                    Servlet servlet = servlets[i];
                    String prinName = servlet.getPrincipalName();
                    String sn = servlet.getServletName();
                    runAs.put(sn, prinName);
                }
            } else {

                SecurityRoleMapping[] srmList = sunSipDesc.getSecurityRoleMapping();

                //SecurityRoleMapping[] srmList = ((WebBundleDescriptor) descriptor).getSunDescriptor().getSecurityRoleMapping();
                SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryMgr.getFactory();

                //super.getDescriptor().getApplication().getRoleMapper().getName();
                if (srmList == null) {
                    return runAs;
                }
                Iterator<String> itr = srMap.keySet().iterator();
                while (itr.hasNext()) {
                    String servletName = itr.next();
                    if (!runAs.containsKey(servletName)) {
                        for (int si = 0; si < srmList.length; si++) {
                            SecurityRoleMapping srm = srmList[si];
                            String role = srm.getRoleName();
                            List<PrincipalNameDescriptor> principals = srm.getPrincipalNames();
                            if ((srMap.containsValue(role) && principals.size() > 0)) {
                                Principal principal = principals.get(0).getPrincipal();
                                runAs.put(servletName, principal.getName());
                                break;
                            }
                        }
                    }
                }
            }
        }
        return runAs;
    }
}
