/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.sip.container;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import java.util.Properties;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;


public class PropertiesImporter implements LifecycleListener {
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_start".equals(event.getType())) {
            // Importing Properties
            File propFile = new File(System.getProperty("catalina.home") +
                    "/conf/system.properties");

            Properties sysProps = new Properties(System.getProperties());

            try {
                sysProps.load(new FileInputStream(propFile));
                System.setProperties(sysProps);
            } catch (Exception e) {
                e.printStackTrace();
            }

            // Importing Properties
            loadPreferenceProperties();
        }
    }

    private void loadPreferenceProperties() {
        String preferenceDirectory = "preferences";
        String catalinaHome = System.getProperty("catalina.home");

        if (catalinaHome != null) {
            preferenceDirectory = catalinaHome + "/conf/preferences";
        }

        try {
            File preferenceDir = new File(preferenceDirectory);

            File[] prefFiles = preferenceDir.listFiles();

            for (int i = 0; i < prefFiles.length; i++) {
                if (prefFiles[i].isDirectory()) {
                    continue;
                }

                String currentFile = prefFiles[i].getName();
                System.out.println("Processing Preferences from " +
                    currentFile);

                FileInputStream fis = new FileInputStream(prefFiles[i]);
                Preferences.importPreferences(fis);
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (InvalidPreferencesFormatException e) {
            e.printStackTrace();
        }
    }
}
