/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.annotations;

import java.io.File;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.annotation.SipApplicationKey;


/**
 * Descriptor for SIP Annotations
 *
 * @author lmcpepe
 *
 */
public class SipAnnotationDescriptor {
    // Annotations
    Method anno_SipApplicationKey = null;
    private ClassLoader loader = null;
    private String classRepository = null;
    private ArrayList<String> repositoryClasses = new ArrayList<String>();

    public SipAnnotationDescriptor(ClassLoader cl, String repository) {
        loader = cl;
        classRepository = repository;
    }

    public void processAnnotations() {
        scanDirectory(new File(classRepository), null);

        for (Iterator iter = repositoryClasses.iterator(); iter.hasNext();) {
            String element = (String) iter.next();

            try {
                Class clazz = loader.loadClass(element);
                Method[] method = clazz.getMethods();

                // Loop All Methods
                for (int i = 0; i < method.length; i++) {
                    Annotation[] methodAnnotation = method[i].getDeclaredAnnotations();

                    for (int j = 0; j < methodAnnotation.length; j++) {
                        Class annotationType = methodAnnotation[j].annotationType();

                        if (annotationType.getName()
                                              .equals(SipApplicationKey.class.getName())) {
                            anno_SipApplicationKey = method[i];
                        }
                    }
                }
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void scanDirectory(File file, String pckage) {
        if (pckage == null) {
            pckage = "";
        }

        if (file.isDirectory()) {
            File[] files = file.listFiles();

            for (int i = 0; i < files.length; i++) {
                File aFile = files[i];

                if (aFile.isDirectory()) {
                    scanDirectory(aFile, pckage + aFile.getName() + ".");
                } else {
                    String fileName = aFile.getName();

                    if (fileName.endsWith(".class")) {
                        fileName = fileName.substring(0,
                                fileName.indexOf(".class"));

                        String deployedClass = pckage + fileName;
                        repositoryClasses.add(deployedClass);
                    }
                }
            }
        } else if (file.isFile()) {
            String deployedClass = pckage + file.getName();
            repositoryClasses.add(deployedClass);
        }
    }

    public boolean hasSipApplicationKey() {
        return (anno_SipApplicationKey != null) ? true : false;
    }

    public Method getSipApplicationKeyMethod() {
        return anno_SipApplicationKey;
    }

    public String invokeSipApplicationKey(SipServletRequest request)
        throws IllegalArgumentException, IllegalAccessException,
            InvocationTargetException {
        String result = "";
        result = (String) anno_SipApplicationKey.invoke(null,
                new Object[] { request });

        return result;
    }
}
