/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.event.ConfigEventMulticaster;
import java.util.Map;


/**
 * Configuration interface
 *
 * @author eandbur
 * @since Apr 16, 2007
 *
 */
public interface Config {
    public static final String GLOBAL_NODE = "GLOBAL";
    
    /**
     * Get all the key value pairs contained in the node. 
     * @param node 
     * @return all the key value pairs
     */
    public Map<String, String> getAll(String node);

    /**
     * Set the value for a configuration key in the configuration repository.
     *
     * @param key
     * @param value
     */
    public void set(String key, String value);

    /**
     * Set the value of a configuration key for a certain node in the
     * configuration repository. The configuration key will be set on global
     * level if node equals GLOBAL_NODE.
     *
     * @param node
     * @param key
     * @param value
     */
    public void set(String node, String key, String value);

    /**
     * Get the value of a configuration key from the configuration repository.
     *
     * @param key
     * @return
     */
    public String get(String key);

    /**
     * Get the value of a configuration key for a certain node from the
     * configuration repository.
     *
     * @param node
     * @param key
     * @return
     */
    public String get(String node, String key);

    String[] getChildNames(String node);

    /**
     * Clear all specific configuration for this node.
     */
    public void clear();

    /**
     * Clear all configuration.
     */
    public void clearAll();

    /**
     * Clear all node specific configuration.
     *
     * @param node
     */
    public void clear(String node);

    /**
     * Remove the configuration key from a certain node.
     *
     * @param node
     * @param key
     */
    public void remove(String node, String key);
    
    /**
     * Remove node including childeren.
     *
     * @param node
     */
    public void remove(String node);

    /**
     * Copy all node specific configuration to another node.
     *
     * @param fromNode
     * @param toNode
     */
    public void copyConfig(String fromNode, String toNode);

    void setEventMulticaster(ConfigEventMulticaster eventMulticaster);
}
