/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.annotations.ConfigurationAnnotationIntrospector;
import com.ericsson.ssa.config.event.ConfigEventMulticaster;


/**
 * ConfigFactory used to fetching an instance of the Config interface.
 *
 * @author eandbur
 * @since Apr 16, 2007
 *
 */
public class ConfigFactory extends ConfigEventMulticaster {
    private static final ConfigFactory INSTANCE = new ConfigFactory();
    private Config _config = null;

    public static ConfigFactory instance() {
        return INSTANCE;
    }

    /**
     * Fetch a instance of Config.
     *
     * @return
     */
    public static Config getConfig() {
        return INSTANCE._config;
    }

    public void registerConfig(Config config) {
        _config = config;
        _config.setEventMulticaster(this);
    }

    public void deregisterConfig() {
        if (_config != null) {
            _config.setEventMulticaster(null);
            _config = null;
        }
    }
    
    /**
     * Activate configuration for the object provided.
     * The object must be annotated with the Configuration annotation for 
     * at least one method (property setter in most cases) to be a configurable
     * else it will be ignored.
     * Note that this will keep a reference to the configurable.
     * 
     * @param configurable The object that is to be activated for configuration.
     */
    public void activateConfiguration(Object configurable) {
        ConfigurationAnnotationIntrospector.instance().activateConfiguration(configurable);
    }
    
    /**
     * Deactivate configuration for the configurable provided.
     * If the configurable was activated before it will be deactivated. Note that
     * no original value or default value is infused prior deactivation instead
     * the latest configured value remains.
     * The reference to the configurable will be removed.
     * 
     * @param configurable The object that is to be deactivated for configuration.
     */
    public void deactivateConfiguration(Object configurable) {
        ConfigurationAnnotationIntrospector.instance().activateConfiguration(configurable);
    }
}
