/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipSessionsUtil;
import javax.servlet.sip.TimerService;

import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.WARDirContext;
import org.jvnet.glassfish.comms.deployment.backend.SipBundleDescriptor;
import org.jvnet.glassfish.comms.security.util.PolicyBuilder;

import com.ericsson.eas.telurl.TelUrlResolver;

import com.ericsson.ssa.config.ConvergedContext;
import com.ericsson.ssa.config.ConvergedContextRuleSet;
import com.ericsson.ssa.config.SARDirContext;
import com.ericsson.ssa.config.SipFactoryFacade;
import com.ericsson.ssa.container.auth.DescriptorProcessor;
import com.ericsson.ssa.container.sim.ApplicationDispatcher;
import com.ericsson.ssa.container.sim.ServletDispatcher;
import com.ericsson.ssa.dd.ConvergedDescriptor;

/* import com.ericsson.ssa.dd.EjbLocalReference;
import com.ericsson.ssa.dd.EjbReference;
import com.ericsson.ssa.dd.EnvironmentEntry;
import com.ericsson.ssa.dd.Parameter;
import com.ericsson.ssa.dd.ResourceEnvironmentReference;
import com.ericsson.ssa.dd.ResourceReference;
import com.ericsson.ssa.dd.SecurityRole;
import com.ericsson.ssa.dd.SipApplicationListeners; */
import com.ericsson.ssa.dd.SipParser;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipSessionsUtilImpl;
import com.ericsson.ssa.sip.dns.DnsResolver;
import com.ericsson.ssa.sip.timer.TimerServiceImpl;

import com.ericsson.ssa.utils.InjectionUtil;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.web.WebModuleContextConfig;

import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.deploy.ContextEjbDecorator;
import com.sun.enterprise.web.deploy.ContextEnvironmentDecorator;
import com.sun.enterprise.web.deploy.ContextLocalEjbDecorator;
import com.sun.enterprise.web.deploy.ContextResourceDecorator;


import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.web.ResourceReference;
import com.sun.enterprise.deployment.web.EnvironmentEntry;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.SecurityRole;

import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.runtime.common.DefaultResourcePrincipal;
import com.sun.enterprise.deployment.runtime.common.ResourceRef;

import com.sun.org.apache.commons.digester.Digester;
import com.sun.org.apache.commons.digester.RuleSet;

import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.NamingRuleSet;

import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.WARDirContext;

import org.jvnet.glassfish.comms.deployment.backend.SipBundleDescriptor;
import org.jvnet.glassfish.comms.deployment.backend.SipApplicationListeners;
import org.jvnet.glassfish.comms.deployment.backend.Parameter;
import org.jvnet.glassfish.comms.security.util.PolicyBuilder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import java.net.URL;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.*;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipSessionsUtil;

import org.jvnet.glassfish.comms.deployment.backend.SipApplication;
import org.jvnet.glassfish.comms.deployment.runtime.sip.SunSipApp;



public final class ConvergedContextConfig extends WebModuleContextConfig {
    private static final String APPLICATION_SIP_XML = "/WEB-INF/sip.xml";
    protected NamingManager namingManager;
    Switch theSwitch;
    protected ConvergedContextImpl convergedContext;
    boolean contextConfigOk = true;
    
    
    private static final String SIP = "sip";
    private static final String SIP_FACTORY_NAME = "SipFactory";
    private static final String SIP_TIMERSERVICE_NAME = "TimerService";    
    private static final String SIP_SESSIONS_UTIL_NAME = "SipSessionsUtil";
  
    public ConvergedContextConfig() {
        theSwitch = Switch.getSwitch();
        namingManager = theSwitch.getNamingManager();
    }

    /**
     * Create (if necessary) and return a Digester configured to process the
     * context configuration descriptor for an application.
     */
    protected Digester createContextDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);

        RuleSet contextRuleSet = new ConvergedContextRuleSet("", false);
        digester.addRuleSet(contextRuleSet);

        RuleSet namingRuleSet = new NamingRuleSet("Context/");
        digester.addRuleSet(namingRuleSet);

        return digester;
    }

    /**
     * Process events for an associated Context.
     *
     * @param event The lifecycle event that has occurred
     */
    public void lifecycleEvent(LifecycleEvent event) {

        if (event.getType().equals(Lifecycle.INIT_EVENT)) {
            try {
                convergedContext = (ConvergedContextImpl) event.getLifecycle();
            	preConfigureServletContextAttributes();
            } catch (ClassCastException e) {
                return;
            }

        } else if (event.getType().equals(Lifecycle.AFTER_START_EVENT)) {
        	postConfigureServletContextAttributes();
        }

        super.lifecycleEvent(event);
    }

    /**
     * Process a "before start" event for this Context.
     */
    protected void beforeStart() {
        try {
            getSipApplication();
        } catch (Exception e) {
            //log exception
            System.out.print(e.getMessage());
            
        }
    }

    /**
     * Process a "start" event for this Context.
     */
    protected synchronized void start() {
        beforeStart();
        super.start();
        ok = true;

        // Set properties based on DefaultContext
        Container container = context.getParent();

        if (!context.getOverride()) {
            if (container instanceof Host) {
                container = container.getParent();
            }
        }

        ServletContext servletContext = context.getServletContext();
        InputStream sipXml = servletContext.getResourceAsStream(APPLICATION_SIP_XML);

        if (sipXml != null) {
            // Do the SIP servlet specific part.
            try {
                /*
                 * The sequence to start a context 1. Parse the deployment descriptor into a
                 * SipApplication 2. Copy Context Parameters to the Standard Context of
                 * Tomcat 3. bind resources to the context 4. Initialize the servlet
                 * dispatcher
                 */
                configureServletContextAttributes();
                copyContextProperties();
                                
                initializeServletDispatcher();
                PolicyBuilder builder = new PolicyBuilder();
		org.jvnet.glassfish.comms.security.auth.impl.PAssertedAuthenticatorFactory.getInstance();
                String pContextId = super.getDescriptor().getApplication().getRegistrationName() +
                        "/_" + super.getDescriptor().getUniqueFriendlyId();
                builder.createRoleMapper(super.getDescriptor(), pContextId);
               // builder.addRunAs(super.getDescriptor(),convergedContext.getRealm());
                new DescriptorProcessor().process(context.getName(),pContextId,
                    convergedContext.getSipApplication());

                convergedContext.getDispatcher().setContextId(pContextId);
                SipApplication application = convergedContext.getSipApplication();
                Map<String, org.jvnet.glassfish.comms.deployment.backend.Servlet> map = application.getServlets();
                Collection<org.jvnet.glassfish.comms.deployment.backend.Servlet> coll = map.values();
                Iterator<org.jvnet.glassfish.comms.deployment.backend.Servlet> itr = coll.iterator();
                HashMap<String,String> runAsMap = new HashMap<String,String>();
                while (itr.hasNext()) {
                    org.jvnet.glassfish.comms.deployment.backend.Servlet servlet =
                            itr.next();
                    String rolename = servlet.getRunAsRoleName();
                    String servletName = servlet.getServletName();
                    runAsMap.put(servletName,rolename);
                }
                if(runAsMap.size() >0){
                    convergedContext.getDispatcher().getAuthModule().setRunAs(builder.readRunAs(super.getDescriptor(),runAsMap));
                }
                
            } catch (Exception e) {
                e.printStackTrace();
                ok = false;
            }
        }

        // Make our application available if no problems were encountered
        if (ok && contextConfigOk ) {
            context.setConfigured(true);
            logger.log(Level.INFO, "contextConfig.available "+context.getName());            
        } else {
            logger.log(Level.WARNING, "contextConfig.unavailable");
            context.setAvailable(false);
        }
    }

    /**
     * Upon stop of context, all allocated resources and references are reset
     */
    protected synchronized void stop() {
        super.stop();

        // Notify ServletContextListener.contextDestroyed here.
        if (convergedContext.getSipApplicationListeners() != null) {
            ServletContextEvent servletContextEvent = new ServletContextEvent(context.getServletContext());
            Iterator<ServletContextListener> contextListenerIterator = convergedContext.getSipApplicationListeners()
                                                                                       .getServletContextListener()
                                                                                       .iterator();

            while (contextListenerIterator.hasNext()) {
                ServletContextListener listener = contextListenerIterator.next();
                listener.contextDestroyed(servletContextEvent);
            }
        }

        // Calling the un-initialize method to call the
        // destroy method on the servlet(s).
        if (convergedContext.getDispatcher() != null) {
            convergedContext.getDispatcher().unInitialize();
        }

        if (convergedContext.getSipApplicationListeners() != null) {
            convergedContext.getSipApplicationListeners().clean();
        }

        convergedContext.setSipApplication(null);
        convergedContext.setDispatcher(null);
        convergedContext.setSipFactory(null);
        convergedContext.setSipSessionsUtil(null);
        
        
        
        unPublishResourceReference( getSipResourceJNDIName(SIP_FACTORY_NAME));
        SipFactoryMap.getInstance()
        .removeSipFactoryFacade(getSipResourceJNDIName(SIP_FACTORY_NAME));
        
        unPublishResourceReference( getSipResourceJNDIName(SIP_SESSIONS_UTIL_NAME) );
        SipSessionsUtilMap.getInstance().removeSipSessionsUtil(getSipResourceJNDIName(SIP_SESSIONS_UTIL_NAME));
        
        unPublishResourceReference( getSipResourceJNDIName(SIP_TIMERSERVICE_NAME));

    }

    /**
     * Process a "destroy" event for this Context.
     */
    protected synchronized void destroy() {
        String workDir = ((StandardContext) context).getWorkPath();

        if (workDir != null) {
            ExpandWar.delete(new File(workDir));
        }
    }

    /**
     * configureServletContextAttributes is called upon start of contextconfig.
     *
     */
    private void configureServletContextAttributes()
    {
        SipApplication sipApplication = convergedContext.getSipApplication();
        ServletContext servletContext = convergedContext.getServletContext();
        
        SipApplicationListeners sipApplicationListeners =
            new SipApplicationListeners(((SipApplication)sipApplication).getListeners(),
            context.getLoader().getClassLoader() );
        
        convergedContext.setSipApplicationListeners(sipApplicationListeners);

        // Notify the ServletContextListener.contextInitialized here.
        ServletContextEvent servletContextEvent = new ServletContextEvent(servletContext);
        Iterator<ServletContextListener> contextListenerIterator = sipApplicationListeners.getServletContextListener()
                                                                                          .iterator();
        while (contextListenerIterator.hasNext()) {
            ServletContextListener listener = contextListenerIterator.next();
            listener.contextInitialized(servletContextEvent);
        }
        
    }
    

    private void postConfigureServletContextAttributes() {
        SipApplication sipApplication = convergedContext.getSipApplication();
        ServletContext servletContext = convergedContext.getServletContext();
        SipBundleDescriptor sbd = (SipBundleDescriptor) getDescriptor();

        SipApplicationListeners sipApplicationListeners =  convergedContext.getSipApplicationListeners();
        
        InjectionUtil injectionUtil = new InjectionUtil();
        
        Set<Object> instances = sipApplicationListeners.getListenerInstances();
        for( Object instance : instances ){
        	injectionUtil.injectResources(instance, context, sbd);
        }
        
    }
    
    /*
     * PreConfigure must be called upon "init" LifeCycleEvent and before super class
     * has processed the "init event" The method publishes the SipFactory, SipSessionsUtil
     * and TimerService Reference in JNDI
     */
    private void preConfigureServletContextAttributes() {
        
        contextConfigOk = true;
        try {
            getSipApplication();
        } catch (Exception e) {
            contextConfigOk = false;
            logger.log(Level.WARNING, "contextConfig.unavailable");
        }
		
    	SipApplication sipApplication = convergedContext.getSipApplication();
        ServletContext servletContext = convergedContext.getServletContext();

        // SSA 1.0, section 4.2, here we can add new extensions.
        // The only extensions we support right now is 100rel and path.
        List<String> supportedExt = new ArrayList<String>();
        supportedExt.add("100rel");
        supportedExt.add("path");
        servletContext.setAttribute("javax.servlet.sip.supported", supportedExt);

        SipFactoryImpl.getInstance()
                      .setServiceHandler(ApplicationDispatcher.getInstance());

        /*
         * SipFactory
         */
        SipFactoryFacade sipFactory = new SipFactoryFacade(convergedContext,
                SipFactoryImpl.getInstance(),(SipApplication)sipApplication);
        convergedContext.setSipFactory(sipFactory);
        servletContext.setAttribute(SipServlet.SIP_FACTORY, sipFactory);

        SipFactoryMap.getInstance()
        .addSipFactoryFacade(getSipResourceJNDIName(SIP_FACTORY_NAME), sipFactory);

        
        /*
         * SipSessionsUtil
         */
        SipSessionsUtilImpl sipSessionsUtil = new SipSessionsUtilImpl(convergedContext);
        convergedContext.setSipSessionsUtil(sipSessionsUtil);
        servletContext.setAttribute("javax.servlet.sip.SipSessionsUtil", sipSessionsUtil);
        
        (SipSessionsUtilMap.getInstance()).addSipSessionsUtil(getSipResourceJNDIName(SIP_SESSIONS_UTIL_NAME), 
        		(SipSessionsUtil) sipSessionsUtil);


        // Bind the timer service
        servletContext.setAttribute(SipServlet.TIMER_SERVICE,
            TimerServiceImpl.getInstance());

        //Needed by applications which needs direct TelUrl lookup support
        servletContext.setAttribute(TelUrlResolver.CONTEXT_ATTRIBUTE_NAME,
            DnsResolver.getInstance());

        SipBundleDescriptor sbd = (SipBundleDescriptor) getDescriptor();

        for (Iterator itr = sbd.getJmsDestinationReferenceDescriptors()
                               .iterator(); itr.hasNext();) {
        	JmsDestinationReferenceDescriptor next = (JmsDestinationReferenceDescriptor) itr.next();

            String resourceType = next.getRefType();

            if (javax.servlet.sip.SipFactory.class.getName().equals(resourceType)) {
            	updateDescriptor(next,SIP_FACTORY_NAME);
            } else if (javax.servlet.sip.TimerService.class.getName().equals(resourceType)) {
            	updateDescriptor(next,SIP_TIMERSERVICE_NAME);            	
            } else if (javax.servlet.sip.SipSessionsUtil.class.getName().equals(resourceType)) {
            	updateDescriptor(next,SIP_SESSIONS_UTIL_NAME);
            }
        }

        publishResourceReference(SipFactory.class.getName(),
            "org.jvnet.glassfish.comms.deployment.backend.SipFactoryObjectFactory", getSipResourceJNDIName(SIP_FACTORY_NAME));

        publishResourceReference(SipSessionsUtil.class.getName(),
        	"org.jvnet.glassfish.comms.deployment.backend.SSUObjectFactory", getSipResourceJNDIName(SIP_SESSIONS_UTIL_NAME));

        publishResourceReference(TimerService.class.getName(),
        	"org.jvnet.glassfish.comms.deployment.backend.TimerServiceObjectFactory", getSipResourceJNDIName(SIP_TIMERSERVICE_NAME));
    }

  
    
    private void updateDescriptor(JmsDestinationReferenceDescriptor desc, String ResourceName ) {
    	
        desc.setJndiName(getSipResourceJNDIName(ResourceName));
        desc.setMappedName(getSipResourceJNDIName(ResourceName));                
    }
    
    private String getSipResourceJNDIName( String resourceName )
    {
    	return SIP + convergedContext.getName() + "/" + resourceName;
    }
    
    private void publishResourceReference(String resourceInterface,
    		String objectFactory, String mappedName) {
    	try {
    		if (logger.isLoggable(Level.FINE)) {
    			logger.log(Level.FINE, "mappedName = " + mappedName);
    		}

    		Reference ref = new Reference(resourceInterface,
    				new StringRefAddr("url", mappedName), objectFactory, null);

    		namingManager.publishObject(mappedName, ref, true);
    	} catch (NamingException ne) {
    		ne.printStackTrace();
    	}
    }
    

    private void unPublishResourceReference( String mappedName) {
    	try {

    		namingManager.unpublishObject(mappedName);
    	} catch (NamingException ne) {
    		ne.printStackTrace();
    	}
    }
    
    /**
     * Attaches a <code>SipServletInvokerValve</code> to a <code>Context</code>
     * pipeline and registers the valve with the SIM. The initialization steps
     * of the valve are also executed.
     */
    private void initializeServletDispatcher() {
        ServletDispatcher dispatcher = new ServletDispatcher(convergedContext.getSipSessionManager());
        dispatcher.setSipApplicationModel(convergedContext.getSipApplication());
        context.getPipeline().addValve(dispatcher);

        // Initialize all the servlet wrappers upon initialization of the context.
        // Must do this after adding the valve to the pipeline, so that the parent
        // container of the valve and it's Loader are initialized.
        dispatcher.setSipFactory(convergedContext.getSipFactory());
        dispatcher.initialize();
        convergedContext.setDispatcher(dispatcher);
    }

    /**
     * Adjust docBase.
     */
    protected void fixDocBase() throws IOException {
        Host host = (Host) context.getParent();
        String appBase = host.getAppBase();
        boolean unpackWARs = true;

        if (host instanceof StandardHost) {
            unpackWARs = ((StandardHost) host).isUnpackWARs() &&
                ((StandardContext) context).getUnpackWAR();
        }

        File canonicalAppBase = new File(appBase);

        if (canonicalAppBase.isAbsolute()) {
            canonicalAppBase = canonicalAppBase.getCanonicalFile();
        } else {
            canonicalAppBase = new File(System.getProperty("catalina.base"),
                    appBase).getCanonicalFile();
        }

        String docBase = context.getDocBase();

        if (docBase == null) {
            // Trying to guess the docBase according to the path
            String path = context.getPath();

            if (path == null) {
                return;
            }

            if (path.equals("")) {
                docBase = "ROOT";
            } else {
                if (path.startsWith("/")) {
                    docBase = path.substring(1);
                } else {
                    docBase = path;
                }
            }
        }

        File file = new File(docBase);

        if (!file.isAbsolute()) {
            docBase = (new File(canonicalAppBase, docBase)).getPath();
        } else {
            docBase = file.getCanonicalPath();
        }

        file = new File(docBase);

        if ((docBase.toLowerCase().endsWith(".sar") ||
                docBase.toLowerCase().endsWith(".war")) && !file.isDirectory() &&
                unpackWARs) {
            URL war = new URL("jar:" + (new File(docBase)).toURL() + "!/");
            String contextPath = context.getPath();

            if (contextPath.equals("")) {
                contextPath = "ROOT";
            }

            docBase = ExpandWar.expand(host, war, contextPath);
            file = new File(docBase);
            docBase = file.getCanonicalPath();
        } else {
            File docDir = new File(docBase);

            if (!docDir.exists()) {
                String[] extensions = new String[] { ".sar", ".war" };

                for (String extension : extensions) {
                    File archiveFile = new File(docBase + extension);

                    if (archiveFile.exists()) {
                        if (unpackWARs) {
                            URL war = new URL("jar:" + archiveFile.toURL() +
                                    "!/");
                            docBase = ExpandWar.expand(host, war,
                                    context.getPath());
                            file = new File(docBase);
                            docBase = file.getCanonicalPath();
                        } else {
                            docBase = archiveFile.getCanonicalPath();
                        }

                        break;
                    }
                }
            }
        }

        if (docBase.startsWith(canonicalAppBase.getPath())) {
            docBase = docBase.substring(canonicalAppBase.getPath().length());
            docBase = docBase.replace(File.separatorChar, '/');

            if (docBase.startsWith("/")) {
                docBase = docBase.substring(1);
            }
        } else {
            docBase = docBase.replace(File.separatorChar, '/');
        }

        context.setDocBase(docBase);
    }

    // =================================================================
    // Copy parameters from the SipApplication Model to the Context
    //
    //
    private void copyContextProperties() {
        SipApplication sipApplication = convergedContext.getSipApplication();
        if(sipApplication.getDisplayName() != null ) {
             convergedContext.setDisplayName(sipApplication.getDisplayName());
        }
        convergedContext.setAppName(sipApplication.getAppName());
        context.setDistributable(sipApplication.isDistributable());
        copyContextParameters();
        copySecurityRoles();
        configureContextResource(convergedContext, sipApplication);
        configureResourceRefs(convergedContext, sipApplication);
        configureEjbReferences(convergedContext, sipApplication);
        //copyResourceEnvRefs();
        //copyResourceRefs();

        //copyEnvironmentEntries();
        //copyEjbReferences();
        //copyEjbLocalReferences();
    }

    private void copySecurityRoles() {
        Enumeration<SecurityRole> roles = convergedContext.getSipApplication()
                                                          .getSecurityRoles();

        if (roles != null) {
            for (Enumeration e = roles; roles.hasMoreElements(); ) {
                context.addSecurityRole((roles.nextElement()).getName());
            }
        }
    }

    private void copyContextParameters() {
        Enumeration<ContextParameter> parameters = convergedContext.getSipApplication()
                                                            .getContextParameters();

        if (parameters != null) {
            for (Enumeration e=parameters; e.hasMoreElements(); ){
                ContextParameter param = (ContextParameter)e.nextElement();
                // Check if this is an internal session case
                context.addParameter(param.getName(), param.getValue());
            }
        }
    }

    /**
     * Get base path.
     */
    private String getBasePath(StandardContext context) {
        String docBase = null;
        Container container = context;

        while (container != null) {
            if (container instanceof Host) {
                break;
            }

            container = container.getParent();
        }

        File file = new File(context.getDocBase());

        if (!file.isAbsolute()) {
            if (container == null) {
                docBase = (new File(engineBase(context), context.getDocBase())).getPath();
            } else {
                // Use the "appBase" property of this container
                String appBase = ((Host) container).getAppBase();
                file = new File(appBase);

                if (!file.isAbsolute()) {
                    file = new File(engineBase(context), appBase);
                }

                docBase = (new File(file, context.getDocBase())).getPath();
            }
        } else {
            docBase = file.getPath();
        }

        return docBase;
    }

    /**
     * Return a File object representing the base directory for the
     * entire servlet container (i.e. the Engine container if present).
     *
     * @param context The StandardContext
     */
    protected File engineBase(StandardContext context) {
        String base = System.getProperty("catalina.base");

        if (base == null) {
            StandardEngine engine = (StandardEngine) context.getParent()
                                                            .getParent();

            base = engine.getBaseDir();
        }

        return new File(base);
    }

    /**
     * Set the resources DirContext object with which this
     * context is associated.
     */
    private void setContextResources() {
        try {
            if ((context.getDocBase() != null) &&
                    (context.getDocBase().endsWith(".war")) &&
                    (!(new File(getBasePath((StandardContext) context))).isDirectory())) {
                context.setResources(new WARDirContext());
            } else if ((context.getDocBase() != null) &&
                    (context.getDocBase().endsWith(".sar")) &&
                    (!(new File(getBasePath((StandardContext) context))).isDirectory())) {
                context.setResources(new SARDirContext());
            } else {
                context.setResources(new FileDirContext());
            }
        } catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE,
                "Error initializing resources: " + e.getMessage());
        }
    }

    private void getSipApplication() throws Exception {
        SipApplication sipApplication = null;

        try {
            if ((super.getDescriptor() != null) &&
                    super.getDescriptor() instanceof SipBundleDescriptor) {
                sipApplication = ((SipBundleDescriptor) super.getDescriptor()).getSipApplication();
                convergedContext.setSipApplication((SipApplication)sipApplication);
            }
        } catch (Exception e) {
            throw e; // Just rethrow.
        }
    }
    
    private void publishSipSessionsUtil(SipSessionsUtil ssu) {
        try {
            String ssuMappedName = "ssu" + context.getName();

            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE,
                    "ssuMappedName = " + ssuMappedName);
            }

            //Create a Reference object to hold the SipFactory here
            Reference ssuRef = new Reference("javax.servlet.sip.SipSessionsUtil",
                    new StringRefAddr("url", ssuMappedName),
                    "org.jvnet.glassfish.comms.deployment.backend.SSUObjectFactory",
                    null);

            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "sSURef" + ssuRef);
            }

            namingManager.publishObject(ssuMappedName, ssuRef,
                false);

            // adding the SipSessionsUtil to the map
            (SipSessionsUtilMap.getInstance()).addSipSessionsUtil(ssuMappedName,
                (SipSessionsUtil) ssu);
        } catch (NamingException ne) {
            ne.printStackTrace();
        }        
        
    }
    
    private void unpublishSipSessionsUtil() {
        // Unpublish the SipSessionsUtil from the JNDI namespace
        try {
            namingManager.unpublishObject("ssu" + context.getName());

            //remove the SipFactory from the Map
            SipSessionsUtil ssu = SipSessionsUtilMap.getInstance()
                                         .removeSipSessionsUtil(context.getName());

            if (ssu != null) {
                logger.log(Level.INFO,
                    "SipSessionsUtil object corresponding to" + context.getName() +
                    "removed");
            }
        } catch (NamingException ne) {
            ne.printStackTrace();
        }        
        
    }
    
    protected void configureEjbReferences(ConvergedContextImpl convergedContext,
            SipApplication sipApplication ) {
       Set set = sipApplication.getEjbReferenceDescriptors();
       Iterator iterator =  set.iterator();
       
       EjbReferenceDescriptor ejbDescriptor;
       while( iterator.hasNext() ){
            
           ejbDescriptor = (EjbReferenceDescriptor)iterator.next();
           if ( ejbDescriptor.isLocal() ){
                configureContextLocalEjb(convergedContext, ejbDescriptor);
           } else {
                configureContextEjb(convergedContext, ejbDescriptor);               
           }           
       }          
        
    }
    
    protected void configureContextLocalEjb(WebModule webModule,
                                        EjbReferenceDescriptor ejbDescriptor) {
        ContextLocalEjbDecorator decorator = 
                                new ContextLocalEjbDecorator(ejbDescriptor);
        webModule.addLocalEjb(decorator);
    
    }
    
    /**
     * Configures EJB resource reference for a web application, as
     * represented in a <code>&lt;ejb-local-ref&gt;</code>element in the
     * deployment descriptor.
     */    
    protected void configureContextEjb(WebModule webModule,
                                       EjbReferenceDescriptor ejbDescriptor) {
                                         
        ContextEjbDecorator decorator = new ContextEjbDecorator(ejbDescriptor);
        webModule.addEjb(decorator);
        
    }
    
    /**
     * Configure resource-reference defined in the deployment descriptor.
     */
    protected static void configureResourceRefs(WebModule webModule,
                                               SipApplication sipApp) {
        Set set = sipApp.getEnvironmentProperties();
        if ( set.isEmpty() ){
           return;
        }
        Iterator iterator = set.iterator();
        
        EnvironmentEntry envEntry;
        while(iterator.hasNext()){
            envEntry = (EnvironmentEntry)iterator.next();
            
            webModule.addResourceEnvRef(envEntry.getName(), 
                                        envEntry.getType());
                       
        }                                                                     
    }    
    
    /**
     * Configure a resource reference for a web application, as
     * represented in a <code>&lt;resource-ref&gt;</code> element in the
     * deployment descriptor.
     */    
    protected  void configureContextResource(WebModule webModule,
                                                   SipApplication sipApp) {
        
        Set set = sipApp.getResourceReferenceDescriptors();
        if ( set.isEmpty() ){
            return;
        }
        Iterator iterator = set.iterator();
        
        ResourceReferenceDescriptor resRefDesc;
        ContextResourceDecorator decorator;
        while(iterator.hasNext()){
            resRefDesc = (ResourceReferenceDescriptor)iterator.next();
            decorator = new ContextResourceDecorator(resRefDesc);
                        
            webModule.addResource(decorator);                      
        }
    }
    
    public void configureResources() {
        SipApplication sipApp = convergedContext.getSipApplication();
        SunSipApp sunSipApp = 
                    convergedContext.getSipApplication().getSunSipDescriptor();
        ResourceRef[] rr = sunSipApp.getResourceRef();
        DefaultResourcePrincipal drp;
        ResourcePrincipal rp;
        ResourceReferenceDescriptor resRefDesc;
        ContextResourceDecorator decorator;
         if (rr!=null) {
              for (int j=0; j<rr.length; j++) {
                  if(sipApp.getResourceReferenceByName(rr[j].getResRefName()) != null) {
                        sipApp.getResourceReferenceByName(rr[j].getResRefName()).
                        setJndiName(rr[j].getJndiName());
                        drp = rr[j].getDefaultResourcePrincipal();
                        if (drp!=null) {
                            rp = new ResourcePrincipal(drp.getName(), drp.getPassword());
                            sipApp.getResourceReferenceByName(rr[j].getResRefName()).
                                    setResourcePrincipal(rp);
                        }
                    }
                }
            }            
        }
 }
