/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.config;

import com.sun.org.apache.commons.digester.Digester;
import com.sun.org.apache.commons.digester.Rule;

import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.startup.ContextRuleSet;

import org.xml.sax.Attributes;

import java.lang.reflect.Constructor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 * @author epiesan
 * @since Feb 20, 2006
 */
public class ConvergedContextRuleSet extends ContextRuleSet {
    /**
     * Construct an instance of this <code>RuleSet</code> with the default
     * matching pattern prefix.
     */
    public ConvergedContextRuleSet() {
        this("");
    }

    /**
     * Construct an instance of this <code>RuleSet</code> with the specified
     * matching pattern prefix.
     *
     * @param prefix Prefix for matching pattern rules (including the
     *  trailing slash character)
     */
    public ConvergedContextRuleSet(String prefix) {
        super(prefix);
    }

    /**
     * Construct an instance of this <code>RuleSet</code> with the specified
     * matching pattern prefix.
     *
     * @param prefix Prefix for matching pattern rules (including the
     *  trailing slash character)
     */
    public ConvergedContextRuleSet(String prefix, boolean create) {
        super(prefix);
    }

    /**
     * <p>Add the set of Rule instances defined in this RuleSet to the
     * specified <code>Digester</code> instance, associating them with
     * our namespace URI (if any).  This method should only be called
     * by a Digester instance.</p>
     *
     * @param digester Digester instance to which the new Rule instances
     *  should be added.
     */
    public void addRuleInstances(Digester digester) {
        // GLASSFISH FIXME
        //       if (create) {
        //           digester.addObjectCreate(prefix + "Context",
        //                 com.ericsson.ssa.config.Constants.CONTEXT_CLASS, "className");
        //           digester.addSetProperties(prefix + "Context");
        //       } else {
        //           digester.addRule(prefix + "Context", new SetContextPropertiesRule());
        //       }
        //       digester.addRule(prefix + "Context",
        //                        new CopyParentClassLoaderRule());
        //       if (create) {
        //           digester.addRule(prefix + "Context",
        //                            new LifecycleListenerRule
        //                                (com.ericsson.ssa.config.Constants.CONFIG_CLASS,
        //                                 "configClass"));
        //           digester.addSetNext(prefix + "Context",
        //                               "addChild",
        //                               "org.apache.catalina.Container");
        //       }
        digester.addCallMethod(prefix + "Context/InstanceListener",
            "addInstanceListener", 0);

        digester.addObjectCreate(prefix + "Context/Listener", null, // MUST be specified in the element
            "className");
        digester.addSetProperties(prefix + "Context/Listener");
        digester.addSetNext(prefix + "Context/Listener",
            "addLifecycleListener", "org.apache.catalina.LifecycleListener");

        digester.addRule(prefix + "Context/Loader",
            new CreateLoaderRule("org.apache.catalina.loader.WebappLoader",
                "className"));
        digester.addSetProperties(prefix + "Context/Loader");
        digester.addSetNext(prefix + "Context/Loader", "setLoader",
            "org.apache.catalina.Loader");

        digester.addObjectCreate(prefix + "Context/Manager",
            "org.apache.catalina.session.StandardManager", "className");
        digester.addSetProperties(prefix + "Context/Manager");
        digester.addSetNext(prefix + "Context/Manager", "setManager",
            "org.apache.catalina.Manager");

        digester.addObjectCreate(prefix + "Context/Manager/Store", null, // MUST be specified in the element
            "className");
        digester.addSetProperties(prefix + "Context/Manager/Store");
        digester.addSetNext(prefix + "Context/Manager/Store", "setStore",
            "org.apache.catalina.Store");

        digester.addObjectCreate(prefix + "Context/Parameter",
            "org.apache.catalina.deploy.ApplicationParameter");
        digester.addSetProperties(prefix + "Context/Parameter");
        digester.addSetNext(prefix + "Context/Parameter",
            "addApplicationParameter",
            "org.apache.catalina.deploy.ApplicationParameter");

        digester.addObjectCreate(prefix + "Context/Realm", null, // MUST be specified in the element
            "className");
        digester.addSetProperties(prefix + "Context/Realm");
        digester.addSetNext(prefix + "Context/Realm", "setRealm",
            "org.apache.catalina.Realm");

        digester.addObjectCreate(prefix + "Context/Resources",
            "org.apache.naming.resources.FileDirContext", "className");
        digester.addSetProperties(prefix + "Context/Resources");
        digester.addSetNext(prefix + "Context/Resources", "setResources",
            "javax.naming.directory.DirContext");

        digester.addObjectCreate(prefix + "Context/ResourceLink",
            "org.apache.catalina.deploy.ContextResourceLink");
        digester.addSetProperties(prefix + "Context/ResourceLink");
        //       digester.addRule(prefix + "Context/ResourceLink",
        //               new SetNextNamingRule("addResourceLink",
        //                       "org.apache.catalina.deploy.ContextResourceLink"));
        digester.addObjectCreate(prefix + "Context/Valve", null, // MUST be specified in the element
            "className");
        digester.addSetProperties(prefix + "Context/Valve");
        digester.addSetNext(prefix + "Context/Valve", "addValve",
            "org.apache.catalina.Valve");

        digester.addCallMethod(prefix + "Context/WatchedResource",
            "addWatchedResource", 0);

        digester.addCallMethod(prefix + "Context/WrapperLifecycle",
            "addWrapperLifecycle", 0);

        digester.addCallMethod(prefix + "Context/WrapperListener",
            "addWrapperListener", 0);
    }
}


/**
 * Rule that creates a new <code>Loader</code> instance, with the parent
 * class loader associated with the top object on the stack (which must be
 * a <code>Container</code>), and pushes it on to the stack.
 */
final class CreateLoaderRule extends Rule {
    private static Logger logger = LogUtil.SIP_LOGGER.getLogger();
    private String attributeName;
    private String loaderClass;

    public CreateLoaderRule(String loaderClass, String attributeName) {
        this.loaderClass = loaderClass;
        this.attributeName = attributeName;
    }

    public void begin(String namespace, String name, Attributes attributes)
        throws Exception {
        // Look up the required parent class loader
        ClassLoader parentClassLoader = null;
        Object ojb = digester.peek();

        if (ojb instanceof Container) {
            parentClassLoader = ((Container) ojb).getParentClassLoader();
        }

        // Instantiate a new Loader implementation object
        String className = loaderClass;

        if (attributeName != null) {
            String value = attributes.getValue(attributeName);

            if (value != null) {
                className = value;
            }
        }

        Class clazz = Class.forName(className);
        Class[] types = { ClassLoader.class };
        Object[] args = { parentClassLoader };
        Constructor constructor = clazz.getDeclaredConstructor(types);
        Loader loader = (Loader) constructor.newInstance(args);

        // Push the new loader onto the stack
        digester.push(loader);

        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "new " + loader.getClass().getName());
        }
    }

    public void end(String namespace, String name) throws Exception {
        Loader loader = (Loader) digester.pop();

        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "pop " + loader.getClass().getName());
        }
    }
}
