/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.config;

import java.util.HashMap;

import javax.servlet.sip.SipFactory;


/**
 * Th SipFactoryMap exposes a set of methods to hold the SipFactory instances
 * corresponding to an SipApplication or a ConvergedApplication. A HashMap is
 * used to map the SipFactory instances with the names of the corresponding
 * Sip/Converged Application
 *
 * This class is a singleton, and would have a single Map per instance of the
 * Application Server. As per JSR289, there would never be a need to retrive a
 * SipFactory of an Application which is deployed on another instance of the
 * Application Server.
 *
 * @author lmcpepe
 */
public class SipFactoryMap {
    /** Member variables */
    // SipFactoryMap singleton object
    protected static SipFactoryMap sipFactoryMap = new SipFactoryMap();

    // HashMap where the SipFactory instance for each app is stored.
    private HashMap<String, SipFactoryFacade> sfFacadeMap = new HashMap();

    /** Creates a new instance of SipFactoryMap */
    private SipFactoryMap() {
    }

    /** Public methods */
    public static SipFactoryMap getInstance() {
        return sipFactoryMap;
    }

    /**
     * Adds the instance of the SipFactory associated with an application
     * @param  appName The name of the application whose SipFactory instance is being
     *         stored SipFactory
     * @param  sf The SipFactory object being added
     */
    public void addSipFactoryFacade(String appName, SipFactoryFacade sfFacade) {
        sfFacadeMap.put(appName, sfFacade);
    }

    /**
     * Retrieves the SipFactory instance for a specific application
     * @param the name of the application whose SipFactory instance is to
     *        be retrieved.
     * @return the SipFactory object
     */
    public SipFactoryFacade getSipFactoryFacade(String appName) {
        return (SipFactoryFacade) sfFacadeMap.get(appName);
    }

    /**
     * Removes the SipFactory instance for a particular
     * application
     * @param appName The name of the application whose SipFactory instance is to be
     *        removed from the HashMap
     * @return The SipFactory object that has been removed.
     */
    public SipFactoryFacade removeSipFactoryFacade(String appName) {
        return (SipFactoryFacade) sfFacadeMap.remove(appName);
    }

    /**
     * Checks if the application has a SipFactory mapped
     * @param appName the name of the application for which the check is being
     *                made
     */
    public boolean isSipFactoryFacadeMapped(String appName) {
        return sfFacadeMap.containsKey(appName);
    }
}
