/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.config;

import com.sun.enterprise.web.session.PersistenceType;
import com.sun.enterprise.ee.web.sessmgmt.EEPersistenceTypeResolver;
import java.util.logging.Level;
import org.jvnet.glassfish.comms.util.LogUtil;
import java.util.logging.Logger;

public class SipPersistenceStrategyBuilderFactory {

    private static String sipReplicationBuilderPkg = null;

    private static final Logger logger = LogUtil.SIP_LOGGER.getLogger();

    static {
        try {
            sipReplicationBuilderPkg = Class.forName(
                    "org.jvnet.glassfish.comms.replication.initialization.ReplicatedSipTransactionModifiedSessionStrategyBuilder")
                                             .getPackage().getName();
        } catch (ClassNotFoundException cnfe) {
            throw new ExceptionInInitializerError(cnfe);
        }
    }

    private EEPersistenceTypeResolver persistenceTypeResolver;

    /**
     * Constructor.
     */
    public SipPersistenceStrategyBuilderFactory() {
        persistenceTypeResolver = new EEPersistenceTypeResolver();
    }

    /**
     * Creates and returns the appropriate implementation of a
     * PersistenceStrategyBuilder.
     *
     * @param type Persistence type
     * @param frequency Persistence frequency
     * @param scope Persistence scope
     * @param ctxt
     */
    SipPersistenceStrategyBuilder createPersistenceStrategyBuilder(
        String persistenceType, String frequency, String scope,
        ConvergedContext ctxt) {

        String resolvedPersistenceFrequency = null;
        String resolvedPersistenceScope = null;
        String resolvedPersistenceType =
            persistenceTypeResolver.resolvePersistenceType(persistenceType);

        if (!resolvedPersistenceType.equalsIgnoreCase("memory")) {
            resolvedPersistenceFrequency = frequency;
            resolvedPersistenceScope = scope;
        }
 
        SipPersistenceStrategyBuilder builder = new MemoryStrategyBuilder();
        String className = createBuilderClassNameFrom(
                    resolvedPersistenceType, resolvedPersistenceFrequency,
                    resolvedPersistenceScope);
        try {
            builder = (SipPersistenceStrategyBuilder) Class.forName(className)
                                                           .newInstance();
        } catch (Exception ex) {
            // Log warning that we are falling back to memory
            logger.log(Level.WARNING, "sipstack.invalidSessionManagerConfig",
                new Object[] { ((ConvergedContextImpl) ctxt).getID(), persistenceType,
                frequency, scope });
        }

        builder.setPassedInPersistenceType(persistenceType);

        return builder;
    }

    /**
     * Determines an appropriately camel-cased string that is a candidate
     * class name for a builder.
     *
     * @param type Persistence type
     * @param frequency Persistence frequency
     * @param scope Persistence scope
     *
     * @return The class name of the builder
     */
    private String createBuilderClassNameFrom(String type, String frequency,
                                              String scope) {
        StringBuilder sb = new StringBuilder();
        String pkg = sipReplicationBuilderPkg;
        if ("memory".equalsIgnoreCase(type)) {
            pkg = getClass().getPackage().getName();
        }
        sb.append(pkg + ".");
        sb.append(camelCase(type));

        if (frequency != null) {
            sb.append(camelCase(frequency));
        }

        if (scope != null) {
            sb.append(camelCase(scope));
        }

        sb.append("StrategyBuilder");

        return sb.toString();
    }

    /**
     * Strips out all non-alpha characters from the given input string, and
     * camelCases the result.
     *
     * @param s The input string
     *
     * @return The camelCased result
     */
    private String camelCase(String s) {
        boolean toUpper = true;
        StringBuilder sb = new StringBuilder();

        for (int i = 0; i < s.length(); i++) {
            char nextChar = s.charAt(i);

            if (toUpper) {
                nextChar = Character.toUpperCase(nextChar);
                toUpper = false;
            }

            if (Character.isLetter(nextChar)) {
                sb.append(nextChar);
            } else {
                toUpper = true;
            }
        }

        return sb.toString();
    }
}
