/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.sip.ServiceHandler;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.SipSessionDialogImpl;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;


/**
 * This dispatcher handles forwarding of SIP requests/responses according to SSA
 * 1.0 section 10.2.5. According to that specification the
 * {@link #include(ServletRequest, ServletResponse)} have no meaning in the SIP
 * context.
 */
public class SipRequestDispatcher implements RequestDispatcher {
    private String servletName;
    private ServiceHandler serviceHandler;

    /**
     * Create a dispatcher for the SIP servlet with the specified name.
     *
     * @param servletName
     *           name of servlet
     * @param serviceHandler
     *           the service handler via which servlets can be invoked
     */
    public SipRequestDispatcher(String servletName,
        ServiceHandler serviceHandler) {
        this.servletName = servletName;
        this.serviceHandler = serviceHandler;
    }

    /**
     * {@inheritDoc}
     */
    public void forward(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        SipApplicationSessionImpl session = null;

        if (request != null) {
            if (request instanceof SipServletRequestImpl) {
                session = (SipApplicationSessionImpl) ((SipServletRequestImpl) request).getApplicationSession();
            } else {
                throw new IllegalArgumentException(
                    "Only SIP requests are allowed.");
            }
        }

        if (response != null) {
            if (response instanceof SipServletResponseImpl) {
                if (session == null) {
                    session = (SipApplicationSessionImpl) ((SipServletResponseImpl) response).getApplicationSession();
                }
            } else {
                throw new IllegalArgumentException(
                    "Only SIP responses are allowed.");
            }
        }

        if (session == null) {
            throw new IllegalArgumentException(
                "A SIP request or a SIP response must be supplied.");
        }

        Servlet servlet = serviceHandler.getHandler(session.getName(),
                servletName);

        if (servlet == null) {
            throw new IllegalStateException("SIP servlet " + servletName +
                " not found.");
        }

        // Set the new servlet as handler in the Dialog for Application Path, UAS/Proxy
        SipSessionDialogImpl dialog = (SipSessionDialogImpl) ((SipServletRequest) request).getSession();
        dialog.setHandler(servletName);
        
        // Set servlet as currentServlet in the ApplicationSesson, used for UAC case 
        session.setCurrentServlet(servletName);
        
        servlet.service(request, response);
    }

    /**
     * This method has no meaning in the SIP context according to SSA 1.0 section
     * 10.2.5
     */
    public void include(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        throw new UnsupportedOperationException(
            "This method have no meaning for SIP servlets");
    }
}
