/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.dns.TargetTuple;
import com.ericsson.ssa.sip.timer.GeneralTimer;
import com.ericsson.ssa.sip.timer.GeneralTimerListener;

import java.io.IOException;

import java.net.InetSocketAddress;

import java.nio.channels.SelectableChannel;
import java.util.concurrent.Callable;


/**
 * This is a link of a supported transport
 *
 * @author ehsroha
 * @reveiwed ehsroha 2006-nov-14
 */
public interface Link extends Dispatcher, Callable, GeneralTimerListener {
    /**
     * Indicate that this link has been used and should stay open for yet a while.
     */
    public void markAsActive();

    /**
     * Returns the type of transport supported by this Link e.g. UDP, TCP, TLS,
     * etc.
     *
     * @return the type of transport supported by this Link e.g. UDP, TCP, TLS,
     *         etc.
     */
    public String getTransport();

    /**
     * Returns the target tuple of this link
     *
     * @return the target tuple of this link
     */
    public TargetTuple getTargetTuple();

    /**
     * Tells whether or not this link is open for communication.
     *
     * @return true if, and only if, this link is open
     */
    public boolean isOpen();

    /**
     * Prepares this link for communication
     *
     * @throws IOException
     */
    public void open() throws IOException;

    /**
     * {@inheritDoc}
     */
    public void timeout(GeneralTimer timer);

    /**
     * Ends this link for communication
     *
     * @throws IOException
     */
    public void close() throws IOException;

    /**
     * Returns the underlaying selectable channel used by this link
     *
     * @return the underlaying selectable channel used by this link
     */
    public SelectableChannel getSelectableChannel();

    /**
     * Returns the address of the local endpoint this socket is bound to, or null
     * if it is not bound yet.
     *
     * @return the address of the local endpoint this socket is bound to, or null
     *         if it is not bound yet.
     */
    public InetSocketAddress getLocal();

    /**
     * Returns the address of the endpoint this socket is connected to, or null
     * if it is unconnected.
     *
     * @return the address of the endpoint this socket is connected to, or null
     *         if it is unconnected.
     */
    public InetSocketAddress getRemote();

    /**
     * Returns info about this link
     *
     * @return info about this link
     */
    public String getInfo();
}
