/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.container;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;


/**
 * Help Class for parsing Input Streams
 *
 * @author lmcpepe
 *
 */
public class MessageContent {
    private int bufferSize = 8192;
    private byte[] buffer = new byte[bufferSize];
    private int offset = 0;

    /**
     * Get an input streal
     *
     * @param is
     * @throws IOException
     */
    public MessageContent(InputStream is) throws IOException {
        parseMessageContent(is);
    }

    public void parseMessageContent(InputStream in) throws IOException {
        int toRead = bufferSize;

        do {
            int len;

            if ((len = in.read(buffer, offset, toRead)) < 0) {
                break;
            }

            toRead -= len;
            offset += len;

            if (offset >= bufferSize) {
                bufferSize *= 2;

                byte[] newBuf = new byte[bufferSize];
                System.arraycopy(buffer, 0, newBuf, 0, offset);
                buffer = newBuf;
                toRead = bufferSize - offset;
            }
        } while (true);
    }

    public byte[] getContentAsBytes() {
        return buffer;
    }

    public String getContentAsString() {
        try {
            return new String(buffer, 0, offset, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public int getContentLength() {
        return offset;
    }
}
