/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.container;

import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

import org.jvnet.glassfish.comms.util.LogUtil;
import java.util.logging.Logger;


/**
 * MBean to display counters for Overload situations.
 *
 * @author erafope
 * @since Jan 18, 2007
 *
 * @reviewed ehswolm 2007-feb-23
 */
public class OverloadManager {
    private static OverloadManager singleton = new OverloadManager();
    private static final Logger _log = LogUtil.SIP_LOGGER.getLogger();
    private AtomicLong _EasOverloadRejectedSipRequests = new AtomicLong();
    private AtomicLong _EasOverloadRejectedHttpRequests = new AtomicLong();

    private OverloadManager() {
        // Empty constructor
    }

    public static OverloadManager getInstance() {
        return singleton;
    }

    public long getEasOverloadRejectedSipRequests() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE,
                "PM counter _EasOverloadRejectedSipRequests: " +
                _EasOverloadRejectedSipRequests.toString());
        }
        return _EasOverloadRejectedSipRequests.longValue();
    }

    public long getEasOverloadRejectedHttpRequests() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE,
                "PM counter _EasOverloadRejectedHttpResponses: " +
                _EasOverloadRejectedHttpRequests.toString());
        }
        return _EasOverloadRejectedHttpRequests.longValue();
    }

    public void incrEasOverloadRejectedSipRequests() {
        long curval = _EasOverloadRejectedSipRequests.incrementAndGet();

        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE,
                "Counter EasOverloadRejectedSipRequests incremented: " +
                curval);
        }
    }

    public void incrEasOverloadRejectedHttpRequests() {
        long curval = _EasOverloadRejectedHttpRequests.incrementAndGet();

        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE,
                "Counter EasOverloadRejectedHttpRequests incremented: " +
                curval);
        }
    }
}
