/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.container.startup.SipMonitoring;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.TargetResolver;
import com.ericsson.ssa.sip.dns.TargetTuple;

import com.sun.grizzly.Controller.Protocol;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.util.SSLOutputWriter;
import com.sun.grizzly.util.SSLUtils;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import org.jvnet.glassfish.comms.util.LogUtil;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLEngineResult.HandshakeStatus;
import javax.net.ssl.SSLException;

public class StreamResponseDispatcher implements Dispatcher {

    private final SelectorHandler streamHandler;
    private final SelectionKey key;
    private final Layer backup; //In case of failure using the channel in the context dispatch to backup
    private Logger logger = LogUtil.SIP_LOGGER.getLogger();
    ThreadAttachment currentTA = null;
    /*
     * Need to move this under some attribute in domain.xml
     */
    Boolean enableTlsSyncWrite  = 
            Boolean.getBoolean("org.jvnet.glassfish.comms.enabletlssyncwrite");
    
    private int expectedOutputBufferSize = 
            GrizzlyNetworkManager.DEFAULT_SSL_BB_SIZE;    

    public StreamResponseDispatcher(SelectorHandler handler,
            SelectionKey key, Layer failback) {
        streamHandler = handler;
        this.key = key;
        backup = failback;
        if (handler.protocol() == Protocol.TLS){
            WorkerThread workerThread = ((WorkerThread)Thread.currentThread());
            currentTA = workerThread.getAttachment();
            if (workerThread.getSSLEngine() != null){
                expectedOutputBufferSize = workerThread.getSSLEngine().
                        getSession().getPacketBufferSize()*2;                
            }
        }
    }

    public void dispatch(SipServletRequestImpl req) {
        throw new IllegalStateException("Not designed for connection reuse!");
    }

    public void dispatch(SipServletResponseImpl resp) {
        ByteBuffer bb = null;
        
        try {
            //TODO add a Hash table that makes keeps track if someone is writing and in that case queue.
            resp.toBufferInit();
            Protocol protocol = streamHandler.protocol();            
            synchronized(key.channel()) {                

                while (resp.toBufferHasRemaining()) {
                    bb = GrizzlyNetworkManager.toBuffer(resp);                    
                    if (protocol == Protocol.UDP) {
                        streamHandler.getAsyncQueueWriter().write(key,
                                resp.getRemote().getSocketAddress(), bb,
                                GrizzlyNetworkManager.asyncWriteCallbackHandler);
                    } else if (protocol == Protocol.TCP) {
                        streamHandler.getAsyncQueueWriter().write(key, bb,
                                GrizzlyNetworkManager.asyncWriteCallbackHandler);
                    } else {
                        
                         /*
                         * Attach may not be required for async, required
                         * only for sync write.
                         */
                        if (enableTlsSyncWrite) {
                            if (Thread.currentThread() instanceof WorkerThread) {
                                WorkerThread workerThread =
                                        (WorkerThread) Thread.currentThread();
                                workerThread.attach(currentTA);
                                SSLOutputWriter.flushChannel((SocketChannel) key.channel(), bb);
                            } else {
                                if (logger.isLoggable(Level.WARNING)) {
                                    logger.log(Level.WARNING,
                                            "Trying to dispatch from a SipContainer thread" + "Not yet supported");
                                    return;
                                }
                            }
                        } else {
                            /*
                             * Since we do not clone the byetbufferduring write
                             * , this bytebuffer object
                             * should be the same as the one we used for calling 
                             * asyncqueuewriter.write. We needed a unique identifier corresponding
                             * to the securebb that is created in the dispatcher, so that
                             * this buffer can  be released in the GZNM when the write finishes.
                             * Using the 
                             * hashcode of the buffer, could not think of anything else.
                             */
                            ByteBuffer secureBuffer = 
                                    GrizzlyNetworkManager.acquireSecureBuffer(bb.hashCode(),
                                    expectedOutputBufferSize);
                            secureBuffer.limit(0);
                            SSLWritePreProcessor preProcessor = 
                                    new SSLWritePreProcessor(currentTA.getSSLEngine(),
                                    secureBuffer);
                            streamHandler.getAsyncQueueWriter().write(key, bb,
                                    GrizzlyNetworkManager.asyncWriteCallbackHandler, preProcessor);
                        }
                    }
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                //InetSocketAddress remote = resp.getRemote().getSocketAddress();
                logger.log(Level.FINE, "Network OUT response to remote:'" + resp.getRemote() + "' from local: '" + resp.getLocal() + "' --> \r\n" + resp.toString());
            }

            // SipResponse
            if (SipMonitoring.isEnabled(SipMonitoring.NETWORK_MANAGER)) {
                ((NetworkManager) backup).incrEasSentSipResponses();
            }


        } catch (IOException e) {       
            
            GrizzlyNetworkManager.releaseSecureBuffer(bb.hashCode());
            GrizzlyNetworkManager.releaseBuffer(bb);
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Failed to reuse connection for response", e);
                }
                /**
                 * Calling another layer from the Network manager !
                 */
                TargetTuple targetTuple = 
                        TargetResolver.getInstance().resolveResponse(resp);
                if (targetTuple != null) {
                    resp.setRemote(targetTuple);
                }
            } catch (Exception ex) {
                if (logger.isLoggable(Level.FINE)) {
                    //InetSocketAddress remote = resp.getRemote().getSocketAddress();
                    logger.log(Level.FINE, "Broken connection --> \r\n" + resp.toString());
                }
            }       
            backup.dispatch(resp);
        }
    }
    

    class SSLWritePreProcessor implements AsyncQueueDataProcessor {

        private SSLEngine sslEngine;
        private ByteBuffer securedOutputBuffer;

        public SSLWritePreProcessor(SSLEngine sslEngine, ByteBuffer securedOutputBuffer) {
            this.sslEngine = sslEngine;
            this.securedOutputBuffer = securedOutputBuffer;
        }

        public ByteBuffer getInternalByteBuffer() {
            return securedOutputBuffer;
        }

        public void process(ByteBuffer byteBuffer) throws SSLException {
            if (!byteBuffer.hasRemaining() || securedOutputBuffer.hasRemaining()) {
                return;
            }
            securedOutputBuffer.clear();
            SSLEngineResult result = sslEngine.wrap(byteBuffer, securedOutputBuffer);
            securedOutputBuffer.flip();         

        }
    } 
}
